// GeneralIntegralImage.cpp : Defines the entry point for the console application.
//

#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
#include <stdio.h>
#include <tchar.h>

#ifndef _CRT_SECURE_NO_DEPRECATE
#define _CRT_SECURE_NO_DEPRECATE
#endif

#include "IntegralImage.h"
#include "IntegralSift.h"

//int _tmain(int argc, _TCHAR* argv[])
int main(int argc, char* argv[])
{	IntegralImage* iim = NULL;
	int order = 1, T = 0;
	char filename[1024]; char* pFilename = filename;
	if (argc != 4){
		fprintf(stderr, "Must supply 3 arguments: filename, order, scale\n");
		exit(1);
	}else{
		strcpy(pFilename, argv[1]);
		order =  atoi(argv[2]);
		T = atoi(argv[3]);
	}
	
	iim = new IntegralImage(filename, order);
	//FLOAT normFactor = (FLOAT)pow((FLOAT)mySquare(T), order); if (normFactor < 1) normFactor = 1;	
	iType normFactor = (iType)pow((FLOAT)mySquare(T), order); if (normFactor < 1) normFactor = 1;	
	fprintf(stderr, "kernel is "); iim->dumpKernel(stderr);
	fprintf(stderr, "height is %d, width is %d, order is %d, T is %d, normFactor is %lld\n", iim->getHeight(), iim->getWidth(), iim->getOrder(), T, normFactor);
	
	// convolve image with the largest B-spline
	Image im = Image(iim->getWidth(), iim->getHeight()); im.clearBuffer();
	// convolve with B-spline at scale T	
	int margin = order*T;
	switch(order){
		case 1:
			for (int y = margin; y < (int)im.getHeight()-margin; y++){
				for (int x = margin; x < (int)im.getWidth()-margin; x++){
					im.set((iType)(iim->at1(x, y, T)/normFactor), x, y);
				}
			}
			break;
		case 2:
			for (int y = margin; y < (int)im.getHeight()-margin; y++){
				for (int x = margin; x < (int)im.getWidth()-margin; x++){
					im.set((iType)(iim->at2(x, y, T)/normFactor), x, y);
				}
			}
			break;
		default:
			for (int y = margin; y < (int)im.getHeight()-margin; y++){
				for (int x = margin; x < (int)im.getWidth()-margin; x++){
					im.set((iType)(iim->at(x, y, T)/normFactor), x, y);
				}
			}
	}
	// display the convolved image
	im.write("result1.pgm");
	


	// testing sift detector
	printf("Computing sift features...\n"); fflush(stdout);
		//IntegralSift s(iim, T, 1);	s.compute();	
		//IntegralSift s(iim, T, order%2+1); s.compute();
	// linear scale-space
	if (order == 1){
		IntegralSift s(iim, T, 2);	s.compute();
	}else{
		IntegralSift s(iim, T, 1);	s.compute();
	}
	// logarithmic scale-space
	//IntegralSift s(imm, T, pow(2, 1/3));
	printf("done\n");
	
	if (iim != NULL) delete iim;

	return 0;
}

