#include "Image.h"

/// auxiliary definitions for pgm header
#define STR_SIZE  256
#define LINE_STR_SIZE   75
#define IM_DEPTH 255
typedef enum {
        ASCII,
        BINARY
} FileType;


/// default constructor
Image::Image(){
	width = 0; height = 0; data = NULL;
}
/// constructor for empty image with supplied dimension
Image::Image(int _w, int _h){
	width = _w;
	height = _h;
	data = new iType[width*height];
}
/// construct image from the .pgm file
Image::Image(char* filename){
	data = __readPgmImage(filename, &width, &height);
}

/// desctuctor
Image::~Image(){
	if (data != NULL) delete data; data = NULL;
}

int get_next_line (FILE *fp, char *line)
{
  int first; /* place of first char in line which is not whitespace */
  do /* grab next line from the file. continue grabbing as */
         /* long as the line is a comment or empty:            */
  {
          if (fgets(line,LINE_STR_SIZE+1,fp) == NULL)
              return -1; /* reached eof or error */
          for (first = 0; (line[first] == ' ' || line[first] == '\t'); ++first) ;
  } while ( (line[first] == '#') || (line[first] == '\0') || (line[first] == '\n') );
  if (line[strlen(line) - 1] == '\n')
          line[strlen(line) - 1] = '\0';  /* cutting down the '\n' */
  return 0;
} /* end of 'get_next_line' */

// resets all image element to v
void Image::clearBuffer(iType v){
	iType* pV = data;
	for (int i = 0; i < height*width; i++)
		*pV++ = v;
}


/// read pgm image
iType* Image::__readPgmImage(char* filename, int* outWidth, int* outHeight){
	FILE *in =NULL;
	char str[STR_SIZE];	char str1[STR_SIZE]; char str2[STR_SIZE];

	char line_str[LINE_STR_SIZE];
	FileType file_type;
	int i; int height, width, depth, size; int factor; int val;

	  strcpy(str,filename);
	  
	  if ((in = fopen(str, "rb")) == NULL){
			fprintf(stderr, "Cannot open input file.\n");
			return NULL;
	  }

	  get_next_line(in,line_str);
	  sscanf(line_str,"%s",str);

	  if ((strcmp("p2",str)==0)|(strcmp("P2",str)==0)) {
		file_type=ASCII;
	  } else if ((strcmp("p5",str)==0)|(strcmp("P5",str)==0)) {
		file_type=BINARY;
	  } else {
			  printf("Unknown pgm file format\n");
			  return NULL;
	  }

	  /* in the same line */
	  get_next_line(in,line_str);
	  sscanf(line_str,"%s %s",str1,str2);
	  width=atoi(str1);
	  //printf("width %d\n", width);
	  height=atoi(str2);
	  //printf("height %d\n", height);
	  /* end of same line */

	  get_next_line(in,line_str);
	  sscanf(line_str,"%s",str);
	depth=atoi(str);
	//printf("depth %d\n", IM_DEPTH);

	if (outWidth != NULL) *outWidth = width;
	if (outHeight != NULL) *outHeight = height;
	factor=256/(depth+1);
	size = width*height;
	iType* tmpData = new iType[size];

	if (file_type==ASCII) {
        for (i=0;i<size;i++) {
			fscanf(in,"%i",&val);
            tmpData[i]=(iType)(val*factor);
		}
	}else if (file_type==BINARY) {
		for (i=0;i<size;i++) {
		    tmpData[i]=((iType)fgetc(in))*((iType)factor);
		}
	}

	fclose(in);
	return tmpData;
}


// save image as the pgm
void Image::write(char* filename){
	FILE* ofp;
	ofp = fopen(filename, "wb");
	if (!ofp){
		printf("Error: Unable to open file %s.\n\n", filename);
		exit(1);
	}

	//write the header
	fprintf( ofp, "P5\n" );
	fprintf( ofp, "%d %d\n", width, height);
	fprintf( ofp, "%d\n", IM_DEPTH );
   
	//write the image data
	char* buffer = new char[width*height];
	for (int i = 0; i < width*height; i++)
		buffer[i] = (char)data[i];
	fwrite(buffer, height*width, 1, ofp);	
	delete buffer;
	fclose(ofp);	
}