/* class Image
* Implementation of simple image
*
* Author: Mikhail Sizintsev
* Date: 2007-06-20
*/

#ifndef __IMAGE_H__
#define __IMAGE_H__

extern "C" {
#include <string.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
}

//using namespace std;

typedef long long iType;
//typedef long double FLOAT;
typedef float FLOAT;
//typedef int iType;
#define mySquare(x) ((x)*(x))

class Image{
protected:
	/// image dimensions
	int width;
	int height;

	/// data pointer
	iType* data;

	// read .pgm image
	iType* __readPgmImage(char* filename, int* outWidth = NULL, int* outHeight = NULL);

public:
	/// default constructor
	Image();
	/// constructor for empty image with supplied dimension
	Image(int _w, int _h);
	/// construct image from the .pgm file
	Image(char* filename);
	/// destructor
	~Image();

	// accessor methods
	iType* getData() { return data; }
	int getWidth() { return width; }
	int getHeight() { return height; }
	iType at(int x, int y) { return data[y*width + x]; }
	iType at(int index){ return data[index]; }

	// modifier methods
	void set(iType v, int x, int y) { data[y*width + x] = v; }
	void set(iType v, int index) { data[index] = v; }
	void clearBuffer(iType v = 0);

	// save image as the pgm
	void write(char* filename);
};

#endif

