#include "IntegralImage.h"

/// default constructor
IntegralImage::IntegralImage(){
		order = 1;
		coefs = new iType[order+1]; coefs[0] = -1; coefs[1] = 1;
		height = 0;
		width = 0;
		data = NULL;
		lastVerticalStrip = NULL;
		lastHorizontalStrip = NULL;
}
	
/// construct integral image by loading the image file (pgm supported)
IntegralImage::IntegralImage(char* filename, int _order){

	/// initialize coefficient matrix and normalizing constant
	order = __IImax2(__IImin2(_order, INTEGRAL_IMAGE_MAX_ORDER), 0);
	iType pascalTriag[INTEGRAL_IMAGE_MAX_ORDER+1][INTEGRAL_IMAGE_MAX_ORDER+1];
	coefs = new iType[order+1];	
	// construct the pascal triangle up to the order+1 row and make the kernel out of it
	for (int i = 0; i < order+1; i++){
		pascalTriag[i][0] = 1; // left-most entry
		for (int j = 1; j < i; j++)
			pascalTriag[i][j] = pascalTriag[i-1][j-1] + pascalTriag[i-1][j];
		pascalTriag[i][i] = 1; // right-most entry
	}
	for (int i = 0; i < order+1; i++)
		coefs[i] = ((iType)pow(-1.0, (double)(i+1)))*pascalTriag[order][i];
		
	/// read pgm image
	//iType* auxData = __readPgmImage(filename, &width, &height);
	Image tmpIm(filename);
	width = tmpIm.getWidth();
	height = tmpIm.getHeight();
	iType* auxData = tmpIm.getData();

	/// allocate image memory
	data = new iType[width*height];
	iType* origData = data;
	if (data == NULL) printf("Cannont allocate memory!\n");
	lastVerticalStrip = new iType[height];
	lastHorizontalStrip = new iType[width];
	
	// construct integral image while reading the file
	for (int i = 0; i < order; i++){
		// integrate into data
		data[0] = auxData[0];
		for (int y = 1; y < height; y++) data[y*width] = auxData[y*width] + data[(y-1)*width];
		for (int x = 1; x < width; x++) data[x] = auxData[x] + data[x-1];
		for (int y = 1; y < height; y++){
			iType prev = auxData[y*width];
			for(int x = 1; x < width; x++){
				data[y*width + x] = auxData[y*width+x] + prev + data[(y-1)*width + x];
				prev += auxData[y*width+x];
			}
		}
/*		if (i == order - 2){
			lastVerticalStrip[0] = data[width-1];
			for (int y = 1; y < height; y++){
				lastVerticalStrip[y] = data[y*width+width-1] + lastVerticalStrip[y-1];
			}
			lastHorizontalStrip[0] = data[(height-1)*width];
			for (int x = 1; x < width; x++){
				lastHorizontalStrip[x] = data[(height-1)*width+x] + lastHorizontalStrip[x-1];
			}
			lastElement = data[height*width-1];
		}*/
		// swap data and auxData
		iType* tmp = auxData; auxData = data; data = tmp;
	}
	
	if (origData != data){ // swap data and auxData pointers and erase auxData
		//printf("Swapping pointers\n");
		iType* tmp = auxData; auxData = data; data = tmp;
	}else{ // copy everything to data
		iType* curAux = auxData;
		iType* curData = data;
		for (int i = 0; i < height*width; i++)
			*curData++ = *curAux++;
	}
	//delete [] auxData;
}



/// construct integral image by processing the conventional image
//IntegralImage::IntegralImage(int _order, uImage<T>){}

/// destructor
IntegralImage::~IntegralImage(){
	if (coefs != NULL) delete coefs; coefs = NULL;
	if (data != NULL) delete data; data = NULL;
	if (lastHorizontalStrip != NULL) delete lastHorizontalStrip; lastHorizontalStrip = NULL;
	if (lastVerticalStrip != NULL) delete lastVerticalStrip; lastVerticalStrip = NULL;
}

// extracting aggregated values with approapriate image boundary check
/*iType IntegralImage::at(int x, int y, int T, int normFactor){
	iType result = 0;
	int dx, dy;
	for (int j = 0; j < order+1; j++){
		for (int i = 0; i < order+1; i++){
			dx = x+(order/2-i)*T; dy = y+(order/2-j)*T;			
			// zero-padding of borders
			result += coefs[i]*coefs[j]*data[__IImin2(height,__IImax2(0, dy)) * width + __IImin2(width,__IImax2(0, dx))];
		}
	}
	return result/normFactor;
}*/

// extracting aggregated values without approapriate image boundary check
/*iType IntegralImage::atDirect(int x, int y, FLOAT sigma){
	int normFactor = 0;
	iType result = 0;
	for (int j = 0; j < order+1; j++){
		for (int i = 0; i < order+1; i++){
			result += coefs[i]*coefs[j]*data[(y+j)*width + (x+i)];
		}
	}
	return result/normFactor;
}*/

// dump coefs kernel; for testing purposes
void IntegralImage::dumpKernel(FILE* fp){
	for (int i = 0; i < order+1; i++)
		fprintf(fp, "%d ", coefs[i]);
	fprintf(fp, "\n");
}
