/* class ScaleSpace
* Implementation of simple scalespace (3D image).
* Mainly serves as a wrapper class
*
* Author: Mikhail Sizintsev
* Date: 2007-06-20
*/

#ifndef __SCALE_SPACE_H__
#define __SCALE_SPACE_H__

#include "Image.h"

class ScaleSpace{
protected:
	/// scale-space dimensions
	int width;
	int height;
	int depth;

	/// data pointer
	FLOAT* data;

public:
	/// default constructor
	ScaleSpace(){
		width = 0; height = 0; depth = 0; data = NULL;
	}
	/// constructor for empty scale-space with supplied dimension
	ScaleSpace(int _w, int _h, int _d){
		width = _w; height = _h; depth = _d;
		data = new FLOAT[width*height*depth];
	}
	/// destructor
	~ScaleSpace(){
		if (data != NULL) delete data; data = NULL;
	}

	// accessor methods
	FLOAT* getData() { return data; }
	int getWidth() { return width; }
	int getHeight() { return height; }
	int getDepth() { return depth; }
	FLOAT at(int x, int y, int d) { return data[d*width*height + y*width + x]; }
	FLOAT at(int index){ return data[index]; }

	// modifier methods
	void set(FLOAT v, int x, int y, int d) { data[d*width*height + y*width + x] = v; }
	void set(FLOAT v, int index) { data[index] = v; }
	void clearBuffer(FLOAT v = 0){
		FLOAT* pV = data;
		for (int i = 0; i < height*width; i++)
			*pV++ = v;
	} 
};

#endif

