/*
 * Decompiled with CFR 0.152.
 */
package MarieSimulator;

import MarieSimulator.AssembledCodeLine;
import MarieSimulator.MarieDPath;
import MarieSimulator.TextFileViewer;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.Document;

public class MarieDPath
extends JFrame {
    public static String mexFile = null;
    public static String mexPath = null;
    public static final String MEX_TYPE = ".mex";
    public static final String linefeed = System.getProperty("line.separator");
    public static final String formfeed = "\f";
    public static final String fileSeparator = System.getProperty("file.separator");
    public static final String HELP_FILE = "mdphlp1.txt";
    public static final JFileChooser exeFileChooser = new JFileChooser(System.getProperty("user.dir"));
    public static final int HEX = 0;
    public static final int DEC = 1;
    public static final int ASCII = 2;
    public static final int MAX_MARIE_ADDR = 4095;
    public static final int MARIE_HALTED_NORMAL = 0;
    public static final int MARIE_RUNNING = 1;
    public static final int MARIE_BLOCKED_ON_INPUT = 2;
    public static final int MARIE_PAUSED = 3;
    public static final int MARIE_HALTED_ABNORMAL = -1;
    public static final int MARIE_HALTED_BY_USER = -2;
    public static final int MARIE_NO_PROGRAM_LOADED = -3;
    public static final int MARIE_UNINITIALIZED = 57005;
    static final int PROGRAM_TABLE_ROW_HEIGHT = 19;
    public static final int MINIMUM_DELAY = 10;
    public static final String[] base = new String[]{"Hex", "Dec", "ASCII"};
    public static final int regTopBound = 70;
    public static final int regWidth = 60;
    public static final int regHeight = 25;
    public static final int[] regOffset = new int[]{675, 596, 522, 440, 300, 220, 140, 60};
    public static final String[] regName = new String[]{"MM", "MAR", "PC", "MBR", "AC", "IN", "OUT", "IR"};
    public static final int[] aluXvals = new int[]{368, 388, 393, 403, 408, 428, 418, 378, 368};
    public static final int[] aluYvals = new int[]{105, 105, 115, 115, 105, 105, 132, 132, 105};
    public static final Color panelBackground = new Color(233, 255, 255);
    public static final Color componentLabelColor = new Color(0, 63, 161);
    public static final Color regActiveColor = new Color(255, 237, 41);
    public static final Color regActiveFontColor = new Color(0, 63, 161);
    public static final Color regInactiveColor = new Color(173, 184, 0);
    public static final Color regInactiveFontColor = new Color(35, 0, 151);
    public static final Color rTLFontColor = new Color(0, 63, 161);
    public static final Color busActiveColor = new Color(0, 225, 7);
    public static final Color busInactiveColor = new Color(0, 153, 0);
    public static final Color memoryActiveColor = new Color(255, 248, 61);
    public static final Color memoryInactiveColor = new Color(173, 184, 0);
    public static final Color controllerActiveColor = new Color(255, 200, 200);
    public static final Color componentOutlineColor = new Color(208, 0, 92);
    public static final Color controlLineActiveColor = new Color(255, 0, 38);
    public static final Color controllerInactiveColor = new Color(108, 48, 255);
    public static final Color controlLineInactiveColor = Color.blue;
    public static final Color monitorPanelColor = new Color(0, 155, 215);
    public static final Color controlPanelBackground = new Color(224, 224, 224);
    public static final Color tableHeaderColor = new Color(65, 80, 150);
    public static final Color messageBackground = new Color(100, 220, 255);
    public static final Color registerTextColor = new Color(0, 50, 165);
    public static final Color buttonPanelColor = new Color(200, 220, 255);
    public static final Color programCursorColor = new Color(120, 210, 255);
    public static final int MM = 0;
    public static final int MAR = 1;
    public static final int PC = 2;
    public static final int MBR = 3;
    public static final int AC = 4;
    public static final int IN = 5;
    public static final int OUT = 6;
    public static final int IR = 7;
    int codeLineCount = 0;
    boolean stepping = false;
    boolean fastFetch = false;
    int machineState = 57005;
    int[] memoryArray = new int[4096];
    boolean errorFound = false;
    boolean fatalError = false;
    int errorCode = 0;
    static String statusMessage = null;
    JPanel dataPathSimPane;
    JMenuBar controlBar = new JMenuBar();
    JMenu fileMenu = new JMenu();
    JMenuItem loadFileItem = new JMenuItem();
    JMenuItem restartItem = new JMenuItem();
    JMenuItem resetItem = new JMenuItem();
    JMenuItem exitFileItem = new JMenuItem();
    JButton runStop = new JButton();
    JButton step = new JButton();
    JButton setSpeed = new JButton();
    DelayFrame delayFrame;
    JButton setFastFetch = new JButton();
    JMenu helpMenu = new JMenu();
    JMenuItem getHelp = new JMenuItem();
    TextFileViewer helpViewer;
    JMenuItem helpAbout = new JMenuItem();
    HelpAboutFrame helpAboutFrame;
    DataPathPanel dataPathPanel;
    BasicStroke outline = new BasicStroke(0.5f);
    BasicStroke controlLine = new BasicStroke(2.5f);
    BasicStroke dataBus = new BasicStroke(8.0f);
    ControlUnit controlUnit = new ControlUnit();
    ALU aLU = new ALU();
    MainMemory memory = new MainMemory();
    Register regIR = new Register(7);
    Register regOUTPUT = new Register(6);
    Register regINPUT = new Register(5);
    Register regAC = new Register(4);
    Register regMBR = new Register(3);
    Register regPC = new Register(2);
    Register regMAR = new Register(1);
    JPanel monitorPanel = new JPanel();
    Object[][] programArray;
    JScrollPane programPane = new JScrollPane();
    JTable programTable;
    ProgramTableModel ptm = new ProgramTableModel();
    int programFocusRow = 0;
    Hashtable codeReference = new Hashtable(16, 0.75f);
    JScrollPane tracePane = new JScrollPane();
    TitledBorder tracePaneBorder = new TitledBorder(BorderFactory.createEtchedBorder(), "  IR    OUT    IN     AC     MBR   PC    MAR", 1, 3, new Font("monospaced", 0, 11));
    JPanel controlPanel = new JPanel();
    JPanel buttonPanel = new JPanel();
    JPanel printPanel = new JPanel();
    JLabel printButtonLabel = new JLabel();
    JButton printTrace = new JButton();
    JPanel inputPanel = new JPanel();
    JLabel inputLabel = new JLabel("Input");
    JComboBox inputBase = new JComboBox<String>(base);
    JTextField inputContent = new JTextField();
    JTextArea traceTextArea = new JTextArea();
    JTextField msgField = new JTextField();
    int delay = 1000;
    int briefDelay = 500;
    static /* synthetic */ Class class$MarieSimulator$MarieSim;
    static /* synthetic */ Class class$MarieSimulator$MarieDPath;
    static /* synthetic */ Class class$java$lang$Object;

    int stringToInt(int n, String string) {
        this.errorFound = false;
        String string2 = string.trim();
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        switch (n) {
            case 1: {
                try {
                    n2 = (short)Integer.parseInt(string2, 10);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    this.errorFound = true;
                    return n3;
                }
            }
            case 0: {
                try {
                    n2 = (short)Integer.parseInt(string2, 16);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    this.errorFound = true;
                    return n3;
                }
            }
            case 2: {
                if (string2.length() == 0) {
                    return 0;
                }
                char c = string2.charAt(0);
                return c % 128;
            }
        }
        n3 = n2;
        return n3;
    }

    String to3CharHexStr(int n) {
        if (n < 0) {
            n <<= 20;
        }
        String string = Integer.toHexString(n).toUpperCase();
        switch (string.length()) {
            case 1: {
                string = "00" + string;
                break;
            }
            case 2: {
                string = "0" + string;
                break;
            }
            case 3: {
                break;
            }
            default: {
                string = string.substring(0, 3);
            }
        }
        return string;
    }

    String to4CharHexStr(int n) {
        if (n < 0) {
            n <<= 16;
        }
        String string = Integer.toHexString(n).toUpperCase();
        switch (string.length()) {
            case 1: {
                string = "000" + string;
                break;
            }
            case 2: {
                string = "00" + string;
                break;
            }
            case 3: {
                string = "0" + string;
                break;
            }
            case 4: {
                break;
            }
            default: {
                return string.substring(0, 4);
            }
        }
        return string;
    }

    public MarieDPath() {
        this.enableEvents(64L);
        this.setSize(new Dimension(760, 545));
        this.setIconImage(Toolkit.getDefaultToolkit().createImage((class$MarieSimulator$MarieDPath == null ? (class$MarieSimulator$MarieDPath = MarieDPath.class$("MarieSimulator.MarieDPath")) : class$MarieSimulator$MarieDPath).getResource("M.gif")));
        this.setTitle("MARIE Data Path Simulator");
        this.setResizable(false);
        exeFileChooser.addChoosableFileFilter(new MarieExecutableFileFilter());
        exeFileChooser.removeChoosableFileFilter(exeFileChooser.getAcceptAllFileFilter());
        this.dataPathSimPane = (JPanel)this.getContentPane();
        this.dataPathSimPane.setLayout(null);
        this.dataPathSimPane.setBackground(Color.lightGray);
        this.fileMenu.setText("File");
        this.fileMenu.setMnemonic('F');
        this.fileMenu.setToolTipText("Start here!");
        this.loadFileItem.setText("Load");
        this.loadFileItem.setMnemonic('L');
        this.loadFileItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieDPath.this.getProgram();
            }
        });
        this.restartItem.setText("Restart");
        this.restartItem.setEnabled(false);
        this.restartItem.setMnemonic('E');
        this.restartItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieDPath.this.restart();
            }
        });
        this.resetItem.setText("Reset Simulator");
        this.resetItem.setMnemonic('S');
        this.resetItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieDPath.this.confirmReset();
            }
        });
        this.exitFileItem.setText("Exit");
        this.exitFileItem.setMnemonic('X');
        this.exitFileItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieDPath.this.exitProgram();
            }
        });
        this.fileMenu.add(this.loadFileItem);
        this.fileMenu.add(this.restartItem);
        this.fileMenu.add(this.resetItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitFileItem);
        this.runStop.setText("Run");
        this.runStop.setMnemonic('R');
        this.runStop.setEnabled(false);
        this.runStop.setMaximumSize(new Dimension(70, 27));
        this.runStop.setMinimumSize(new Dimension(70, 27));
        this.runStop.setPreferredSize(new Dimension(70, 27));
        this.runStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (MarieDPath.this.machineState == 1) {
                    MarieDPath.this.runStop.setText("Run");
                    MarieDPath.this.step.setEnabled(true);
                    MarieDPath.this.machineState = -2;
                    MarieDPath.this.setStatusMessage(" Halted at user request.");
                } else {
                    MarieDPath.this.restartItem.setEnabled(true);
                    MarieDPath.this.step.setEnabled(false);
                    MarieDPath.this.runStop.setText("Stop");
                    MarieDPath.this.runStop.setMnemonic('T');
                    MarieDPath.this.runStop.setEnabled(true);
                    if (MarieDPath.this.machineState == 0 || MarieDPath.this.machineState == -1) {
                        MarieDPath.this.restart();
                    }
                    MarieDPath.this.machineState = 1;
                    MarieDPath.this.runProgram();
                }
            }
        });
        this.step.setText("Step");
        this.step.setMnemonic('T');
        this.step.setEnabled(false);
        this.step.setMaximumSize(new Dimension(70, 27));
        this.step.setMinimumSize(new Dimension(70, 27));
        this.step.setPreferredSize(new Dimension(70, 27));
        this.step.setFocusPainted(false);
        this.step.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieDPath.this.restartItem.setEnabled(true);
                if (MarieDPath.this.machineState != 2 && !MarieDPath.this.fatalError) {
                    MarieDPath.this.setStatusMessage(" Press [Step] to continue.");
                    MarieDPath.this.stepping = true;
                    MarieDPath.this.runStop.setText("Stop");
                    MarieDPath.this.runStop.setMnemonic('T');
                    if (MarieDPath.this.machineState == 0 || MarieDPath.this.machineState == -1) {
                        MarieDPath.this.restart();
                    }
                    MarieDPath.this.machineState = 1;
                    MarieDPath.this.runProgram();
                }
            }
        });
        this.setSpeed.setText("Set Speed");
        this.setSpeed.setMnemonic('D');
        this.setSpeed.setMaximumSize(new Dimension(100, 27));
        this.setSpeed.setMinimumSize(new Dimension(100, 27));
        this.setSpeed.setPreferredSize(new Dimension(100, 27));
        this.setSpeed.setFocusPainted(false);
        this.setSpeed.setEnabled(true);
        this.setSpeed.setToolTipText("Set delay between execution steps.");
        this.setSpeed.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieDPath.this.displayDelayFrame();
            }
        });
        this.setFastFetch.setText("Set Fast Fetch On");
        this.setFastFetch.setMnemonic('E');
        this.setFastFetch.setFont(new Font("sanserif", 1, 11));
        this.setFastFetch.setMaximumSize(new Dimension(130, 27));
        this.setFastFetch.setMinimumSize(new Dimension(130, 27));
        this.setFastFetch.setPreferredSize(new Dimension(130, 27));
        this.setFastFetch.setFocusPainted(false);
        this.setFastFetch.setEnabled(true);
        this.setFastFetch.setToolTipText("Turn fast fetch mode on.");
        this.setFastFetch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (MarieDPath.this.fastFetch) {
                    MarieDPath.this.fastFetch = false;
                    MarieDPath.this.setFastFetch.setText("Set Fast Fetch On");
                    MarieDPath.this.setFastFetch.setToolTipText("Turn fast fetch mode on.");
                    MarieDPath.this.setStatusMessage(" Fast fetch mode is off.");
                } else {
                    MarieDPath.this.fastFetch = true;
                    MarieDPath.this.setFastFetch.setText("Set Fast Fetch Off");
                    MarieDPath.this.setFastFetch.setToolTipText("Turn fast fetch mode off.");
                    MarieDPath.this.setStatusMessage(" Fast fetch mode is on.");
                }
            }
        });
        this.getHelp.setText("Help");
        this.getHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieDPath.this.displayHelpFrame();
            }
        });
        this.helpMenu.setText("Help");
        this.helpAbout.setText("About");
        this.helpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieDPath.this.displayHelpAboutFrame();
            }
        });
        this.helpMenu.add(this.getHelp);
        this.helpMenu.add(this.helpAbout);
        this.controlBar.add(this.fileMenu);
        this.controlBar.add(this.runStop);
        this.controlBar.add(this.step);
        this.controlBar.add(this.setSpeed);
        this.controlBar.add(this.setFastFetch);
        this.controlBar.add(this.helpMenu);
        this.setJMenuBar(this.controlBar);
        this.dataPathPanel = new DataPathPanel();
        this.dataPathPanel.setBounds(new Rectangle(1, 1, 749, 240));
        this.dataPathPanel.setBackground(panelBackground);
        this.dataPathPanel.setEnabled(true);
        this.dataPathPanel.setFont(new Font("sanserif", 0, 10));
        this.dataPathPanel.setLayout(null);
        this.dataPathSimPane.add((Component)this.dataPathPanel, null);
        this.monitorPanel.setBounds(new Rectangle(1, 242, 749, 245));
        this.monitorPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.monitorPanel.setBackground(monitorPanelColor);
        this.monitorPanel.setLayout(null);
        this.programPane = this.createProgramPanel();
        this.programPane.setBorder(BorderFactory.createEtchedBorder());
        this.programPane.setBounds(new Rectangle(5, 14, 300, 190));
        this.monitorPanel.add(this.programPane);
        this.controlPanel.setBorder(BorderFactory.createEtchedBorder());
        this.controlPanel.setOpaque(true);
        this.controlPanel.setBounds(new Rectangle(308, 14, 435, 190));
        this.controlPanel.setBackground(controlPanelBackground);
        this.controlPanel.setLayout(null);
        this.buttonPanel.setBounds(new Rectangle(2, 2, 80, 185));
        this.buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 1));
        this.printButtonLabel.setText("Trace");
        this.printButtonLabel.setForeground(registerTextColor);
        this.printButtonLabel.setSize(60, 60);
        this.printPanel.setMinimumSize(new Dimension(72, 80));
        this.printPanel.setMaximumSize(new Dimension(72, 80));
        this.printPanel.setPreferredSize(new Dimension(72, 80));
        this.printPanel.setBackground(buttonPanelColor);
        this.printTrace.setText("Print");
        this.printTrace.setBackground(buttonPanelColor);
        this.printTrace.setForeground(registerTextColor);
        this.printTrace.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieDPath.this.printTraceText();
            }
        });
        this.printPanel.add(this.printButtonLabel);
        this.printPanel.add(this.printTrace);
        this.buttonPanel.add(this.printPanel);
        this.inputPanel.setMinimumSize(new Dimension(80, 95));
        this.inputPanel.setMaximumSize(new Dimension(80, 95));
        this.inputPanel.setPreferredSize(new Dimension(80, 95));
        this.inputPanel.setBackground(buttonPanelColor);
        this.inputPanel.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(3, 2, 2, 3), new EtchedBorder()));
        this.inputPanel.setLayout(new FlowLayout());
        this.inputLabel.setFont(new Font("sanserif", 0, 12));
        this.inputLabel.setForeground(registerTextColor);
        this.inputLabel.setMinimumSize(new Dimension(40, 25));
        this.inputLabel.setToolTipText("Input Register");
        this.inputContent.setMaximumSize(new Dimension(60, 20));
        this.inputContent.setMinimumSize(new Dimension(60, 20));
        this.inputContent.setPreferredSize(new Dimension(60, 20));
        this.inputContent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), new EmptyBorder(0, 10, 0, 0)));
        this.inputContent.setText(" ");
        this.inputContent.setEditable(false);
        this.inputContent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieDPath.this.input();
                MarieDPath.this.inputContent.requestFocus();
            }
        });
        this.inputBase.setSize(new Dimension(60, 20));
        this.inputBase.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(3, 4, 2, 3), new EtchedBorder()));
        this.inputPanel.add(this.inputLabel);
        this.inputPanel.add(this.inputContent);
        this.inputBase.setFont(new Font("sanserif", 0, 10));
        this.inputBase.setBackground(buttonPanelColor);
        this.inputBase.setForeground(registerTextColor);
        this.inputBase.setSelectedIndex(0);
        this.regINPUT.setMode(0);
        this.inputPanel.add(this.inputBase);
        this.inputBase.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = MarieDPath.this.inputBase.getSelectedIndex();
                MarieDPath.this.regINPUT.setMode(n);
                MarieDPath.this.inputContent.setText(MarieDPath.this.regINPUT.toString());
            }
        });
        this.buttonPanel.add(this.inputPanel);
        this.controlPanel.add(this.buttonPanel);
        this.tracePane.setBounds(new Rectangle(82, 2, 350, 185));
        this.tracePaneBorder.setTitleColor(registerTextColor);
        this.tracePane.setBorder(this.tracePaneBorder);
        this.traceTextArea.setFont(new Font("monospaced", 0, 14));
        this.traceTextArea.setText("");
        this.tracePane.getViewport().add((Component)this.traceTextArea, null);
        this.controlPanel.add(this.tracePane);
        this.monitorPanel.add(this.controlPanel);
        this.dataPathSimPane.add(this.monitorPanel);
        this.msgField.setBackground(messageBackground);
        this.msgField.setFont(new Font("SansSerif", 0, 11));
        this.msgField.setBounds(new Rectangle(6, 205, 730, 35));
        this.msgField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(monitorPanelColor, 8), BorderFactory.createLoweredBevelBorder()));
        this.msgField.setEditable(false);
        this.setStatusMessage(" Ready to load program instructions.");
        this.monitorPanel.add(this.msgField);
        this.dataPathPanel.repaint();
    }

    JScrollPane createProgramPanel() {
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel(){
            int colno = 0;

            public void addColumn(TableColumn tableColumn) {
                switch (this.colno) {
                    case 0: {
                        ++this.colno;
                        return;
                    }
                    case 1: {
                        tableColumn.setMinWidth(62);
                        tableColumn.setMaxWidth(62);
                        tableColumn.setPreferredWidth(62);
                        break;
                    }
                    case 4: {
                        tableColumn.setMinWidth(40);
                        tableColumn.setMaxWidth(40);
                        tableColumn.setPreferredWidth(40);
                        break;
                    }
                    default: {
                        tableColumn.setMinWidth(68);
                        tableColumn.setMaxWidth(68);
                    }
                }
                super.addColumn(tableColumn);
                ++this.colno;
                if (this.colno > 4) {
                    this.colno = 0;
                }
            }
        };
        DefaultTableColumnModel defaultTableColumnModel2 = new DefaultTableColumnModel(){
            boolean firstCol = true;

            public void addColumn(TableColumn tableColumn) {
                if (this.firstCol) {
                    tableColumn.setMaxWidth(40);
                    this.firstCol = false;
                    super.addColumn(tableColumn);
                }
            }
        };
        this.programTable = new JTable(this.ptm, defaultTableColumnModel);
        this.programTable.setRowSelectionAllowed(false);
        this.programTable.setCellSelectionEnabled(false);
        this.programTable.setSelectionBackground(Color.white);
        this.programTable.setShowHorizontalLines(false);
        this.programTable.setShowVerticalLines(false);
        this.programTable.setIntercellSpacing(new Dimension(0, 1));
        this.programTable.setRowHeight(19);
        class ProgramTableCellRenderer
        extends JLabel
        implements TableCellRenderer {
            private final /* synthetic */ MarieDPath this$0;

            ProgramTableCellRenderer(MarieDPath marieDPath) {
                this.this$0 = marieDPath;
            }

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.setText((String)object);
                this.setFont(new Font("Monospaced", 0, 12));
                this.setOpaque(true);
                this.setBackground(Color.white);
                this.setForeground(Color.black);
                this.setBorder(new EmptyBorder(0, 0, 0, 0));
                if (n == this.this$0.programFocusRow) {
                    this.setBackground(programCursorColor);
                } else {
                    this.setBackground(Color.white);
                }
                return this;
            }
        }
        ProgramTableCellRenderer programTableCellRenderer = new ProgramTableCellRenderer(this);
        this.programTable.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = MarieDPath.class$("java.lang.Object")) : class$java$lang$Object, programTableCellRenderer);
        JTableHeader jTableHeader = this.programTable.getTableHeader();
        jTableHeader.setForeground(tableHeaderColor);
        jTableHeader.setFont(new Font("Dialog", 0, 11));
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setResizingAllowed(false);
        jTableHeader.setBorder(new EtchedBorder(1));
        this.programTable.createDefaultColumnsFromModel();
        JTable jTable = new JTable(this.ptm, defaultTableColumnModel2);
        jTable.createDefaultColumnsFromModel();
        jTable.setMaximumSize(new Dimension(40, 10000));
        jTable.setBackground(Color.lightGray);
        jTable.setShowVerticalLines(false);
        jTable.setSelectionBackground(Color.lightGray);
        jTable.setBorder(new EtchedBorder(1));
        jTable.setColumnSelectionAllowed(false);
        jTable.setCellSelectionEnabled(false);
        class RowHeaderTableCellRenderer
        extends JLabel
        implements TableCellRenderer {
            private final /* synthetic */ MarieDPath this$0;

            RowHeaderTableCellRenderer(MarieDPath marieDPath) {
                this.this$0 = marieDPath;
            }

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.setText((String)object);
                this.setFont(new Font("sanserif", 0, 11));
                this.setForeground(new Color(0, 50, 165));
                return this;
            }
        }
        RowHeaderTableCellRenderer rowHeaderTableCellRenderer = new RowHeaderTableCellRenderer(this);
        jTable.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = MarieDPath.class$("java.lang.Object")) : class$java$lang$Object, rowHeaderTableCellRenderer);
        jTable.setRowHeight(19);
        this.programTable.setSelectionModel(jTable.getSelectionModel());
        JViewport jViewport = new JViewport();
        jViewport.setView(jTable);
        jViewport.setPreferredSize(jTable.getMaximumSize());
        jTable.setAutoResizeMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.programTable, 22, 31);
        this.codeLineCount = 9;
        this.programArray = new Object[9][5];
        int n = 0;
        while (n < 9) {
            this.programArray[n][0] = "  ";
            this.programArray[n][1] = "  ";
            this.programArray[n][2] = "  ";
            this.programArray[n][3] = "  ";
            this.programArray[n][4] = "  ";
            ++n;
        }
        jScrollPane.setRowHeader(jViewport);
        return jScrollPane;
    }

    void confirmReset() {
        JFrame jFrame = new JFrame("Confirm Reset");
        jFrame.setIconImage(Toolkit.getDefaultToolkit().createImage((class$MarieSimulator$MarieSim == null ? (class$MarieSimulator$MarieSim = MarieDPath.class$("MarieSimulator.MarieSim")) : class$MarieSimulator$MarieSim).getResource("M.gif")));
        int n = JOptionPane.showOptionDialog(jFrame, "Are you sure?", "Reset Confirmation", 0, 3, null, new Object[]{"Yes", "No"}, "No");
        if (n == 1) {
            return;
        }
        this.marieReset();
    }

    void displayDelayFrame() {
        try {
            this.delayFrame.show();
            this.delayFrame.requestFocus();
        }
        catch (Exception exception) {
            this.delayFrame = new DelayFrame();
            this.delayFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    MarieDPath.this.delayFrame = null;
                }
            });
        }
    }

    void displayHelpFrame() {
        try {
            this.helpViewer.show();
            this.helpViewer.requestFocus();
        }
        catch (Exception exception) {
            this.helpViewer = new TextFileViewer("Simulator Help", HELP_FILE, false);
            this.helpViewer.setSize(400, 280);
            this.helpViewer.setLocation(350, 50);
            this.helpViewer.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    MarieDPath.this.helpViewer = null;
                }
            });
            this.helpViewer.show();
        }
    }

    void displayHelpAboutFrame() {
        try {
            this.helpAboutFrame.show();
            this.helpAboutFrame.requestFocus();
        }
        catch (Exception exception) {
            this.helpAboutFrame = new HelpAboutFrame(this);
            this.helpAboutFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    MarieDPath.this.helpAboutFrame = null;
                }
            });
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.exitProgram();
        }
    }

    void exitProgram() {
        JFrame jFrame = new JFrame("Confirm Quit");
        jFrame.setIconImage(Toolkit.getDefaultToolkit().createImage((class$MarieSimulator$MarieDPath == null ? (class$MarieSimulator$MarieDPath = MarieDPath.class$("MarieSimulator.MarieDPath")) : class$MarieSimulator$MarieDPath).getResource("M.gif")));
        int n = JOptionPane.showOptionDialog(jFrame, "Really quit?", "Quit Confirmation", 0, 3, null, new Object[]{"Yes", "No"}, "Yes");
        if (n == 0) {
            System.exit(0);
        }
    }

    void setStatusMessage(String string) {
        statusMessage = string;
        this.msgField.setText(statusMessage);
        this.msgField.postActionEvent();
    }

    void printTraceText() {
        Object object;
        BufferedWriter bufferedWriter = null;
        String string = formfeed;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter("datapath.tmp"));
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return;
        }
        try {
            bufferedWriter.write(this.traceTextArea.getText());
            bufferedWriter.write(string);
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return;
        }
        DocFlavor.INPUT_STREAM iNPUT_STREAM = DocFlavor.INPUT_STREAM.AUTOSENSE;
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(iNPUT_STREAM, hashPrintRequestAttributeSet);
        PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
        PrintService printService2 = ServiceUI.printDialog(null, 100, 100, printServiceArray, printService, iNPUT_STREAM, hashPrintRequestAttributeSet);
        if (printService2 != null) {
            try {
                object = printService2.createPrintJob();
                FileInputStream fileInputStream = new FileInputStream("datapath.tmp");
                HashDocAttributeSet hashDocAttributeSet = new HashDocAttributeSet();
                SimpleDoc simpleDoc = new SimpleDoc(fileInputStream, iNPUT_STREAM, hashDocAttributeSet);
                object.print(simpleDoc, hashPrintRequestAttributeSet);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            object = new File("datapath.tmp");
            ((File)object).delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void getProgram() {
        String string = null;
        if (0 != exeFileChooser.showOpenDialog(this)) {
            this.setStatusMessage(" File loading canceled.");
            return;
        }
        string = exeFileChooser.getSelectedFile().getPath();
        int n = 0;
        int n2 = 0;
        n = string.lastIndexOf(fileSeparator);
        if (n < 0) {
            n = -1;
        } else {
            mexPath = string.substring(0, n);
        }
        n2 = string.lastIndexOf(MEX_TYPE);
        if (n2 > 0) {
            mexFile = mexPath + fileSeparator + string.substring(n + 1, n2);
        }
        this.loadProgram();
    }

    void loadProgram() {
        File file = null;
        ObjectInputStream objectInputStream = null;
        AssembledCodeLine assembledCodeLine = new AssembledCodeLine();
        Vector<AssembledCodeLine> vector = new Vector<AssembledCodeLine>();
        this.errorFound = false;
        if (mexFile == null) {
            this.setStatusMessage(" No file to load.  Use File+Load menu picks.");
            return;
        }
        this.runStop.setEnabled(false);
        this.step.setEnabled(false);
        this.restartItem.setEnabled(false);
        try {
            file = new File(mexFile + MEX_TYPE);
            objectInputStream = new ObjectInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.setStatusMessage(" File " + mexFile + MEX_TYPE + " not found.");
            this.errorFound = true;
        }
        catch (IOException iOException) {
            this.setStatusMessage(" " + iOException);
            this.errorFound = true;
        }
        catch (Exception exception) {
            this.setStatusMessage(" " + exception);
            this.errorFound = true;
        }
        if (this.errorFound) {
            return;
        }
        this.marieReset();
        if (this.codeLineCount >= 0) {
            int n = 0;
            while (n < this.codeLineCount) {
                this.programArray[n][0] = "  ";
                this.programArray[n][1] = "  ";
                this.programArray[n][2] = "  ";
                this.programArray[n][3] = "  ";
                this.programArray[n][4] = "  ";
                ++n;
            }
        }
        this.codeLineCount = 0;
        boolean bl = false;
        while (!bl) {
            if (this.codeLineCount >= 4095) {
                this.setStatusMessage(" Maximum program statements reached.");
                this.errorFound = true;
                bl = true;
            }
            try {
                assembledCodeLine = (AssembledCodeLine)objectInputStream.readObject();
                if (assembledCodeLine == null) {
                    bl = true;
                } else if (assembledCodeLine.lineNo.charAt(0) != ' ') {
                    vector.add(assembledCodeLine);
                    ++this.codeLineCount;
                }
            }
            catch (EOFException eOFException) {
                bl = true;
            }
            catch (IOException iOException) {
                this.setStatusMessage(" " + iOException);
                this.errorFound = true;
                bl = true;
            }
            catch (Exception exception) {
                this.setStatusMessage(" " + exception);
                this.errorFound = true;
                bl = true;
            }
            if (bl) break;
        }
        try {
            objectInputStream.close();
            file = null;
        }
        catch (IOException iOException) {
            this.setStatusMessage(" " + iOException);
        }
        if (this.errorFound) {
            return;
        }
        int n = 0;
        this.programArray = new Object[this.codeLineCount][5];
        this.codeReference.clear();
        Enumeration enumeration = vector.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            assembledCodeLine = (AssembledCodeLine)enumeration.nextElement();
            this.programArray[n2][0] = "   " + assembledCodeLine.lineNo;
            this.programArray[n2][1] = assembledCodeLine.stmtLabel;
            this.programArray[n2][2] = assembledCodeLine.mnemonic;
            this.programArray[n2][3] = assembledCodeLine.operandToken;
            this.programArray[n2][4] = " " + assembledCodeLine.hexCode + assembledCodeLine.operand;
            this.codeReference.put(assembledCodeLine.lineNo, new Integer(n2));
            ++n2;
            try {
                n = Integer.parseInt(assembledCodeLine.lineNo, 16);
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            this.memoryArray[n] = Integer.parseInt(assembledCodeLine.hexCode + assembledCodeLine.operand, 16);
        }
        this.ptm.fireTableStructureChanged();
        String string = (String)this.programArray[0][0];
        try {
            n = Integer.parseInt(string.trim(), 16);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.regPC.setValue(n);
        Rectangle rectangle = this.programTable.getCellRect(0, 2, false);
        this.programFocusRow = 0;
        this.programTable.scrollRectToVisible(rectangle);
        this.programPane.repaint();
        this.setStatusMessage(" " + mexPath + fileSeparator + mexFile + MEX_TYPE + " loaded.");
        this.runStop.setEnabled(true);
        this.runStop.setText("Run");
        this.runStop.setMnemonic('R');
        this.step.setEnabled(true);
        this.restartItem.setEnabled(true);
        this.machineState = 0;
    }

    void restart() {
        if (this.machineState == 57005 || this.machineState == -3) {
            return;
        }
        this.fatalError = false;
        this.errorCode = 0;
        if (this.stepping) {
            this.setStatusMessage(" Press [Step] to start.");
            this.step.setEnabled(true);
        } else {
            this.setStatusMessage(" ");
        }
        int n = Integer.parseInt(((String)this.programArray[0][0]).trim(), 16);
        this.regPC.setValue(n);
        Rectangle rectangle = this.programTable.getCellRect(0, 2, false);
        this.programFocusRow = 0;
        this.programTable.scrollRectToVisible(rectangle);
        this.traceTextArea.setText("  IR   OUT    IN    AC   MBR   PC   MAR" + linefeed);
        this.traceTextArea.repaint();
        this.programTable.repaint();
    }

    void marieReset() {
        this.regAC.setValue(0);
        this.regIR.setValue(0);
        this.regMAR.setValue(0);
        this.regMBR.setValue(0);
        this.regPC.setValue(0);
        this.regINPUT.setValue(0);
        this.regOUTPUT.setValue(0);
        this.inputContent.setText("");
        this.traceTextArea.setText("");
        Arrays.fill(this.memoryArray, 0);
        if (this.codeLineCount >= 0) {
            int n = 0;
            while (n < this.codeLineCount) {
                this.programArray[n][0] = "  ";
                this.programArray[n][1] = "  ";
                this.programArray[n][2] = "  ";
                this.programArray[n][3] = "  ";
                this.programArray[n][4] = "  ";
                ++n;
            }
        }
        this.programFocusRow = 0;
        this.machineState = -3;
        this.runStop.setEnabled(false);
        this.restartItem.setEnabled(false);
        this.step.setEnabled(false);
        this.setStatusMessage(" ");
        this.repaint();
    }

    void fetch() {
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int n = 0;
        int n2 = 0;
        if (this.fatalError) {
            this.halt();
            return;
        }
        this.setFastFetch.setEnabled(false);
        if (this.fastFetch) {
            n = this.delay;
            n2 = this.briefDelay;
            this.delay = 10;
            this.briefDelay = 10;
            this.setSpeed.setEnabled(false);
        }
        this.controlBar.repaint();
        String string = this.to3CharHexStr(this.regPC.getValue());
        if (this.codeReference.containsKey(string)) {
            this.programFocusRow = (Integer)this.codeReference.get(string);
            Rectangle rectangle = this.programTable.getCellRect(this.programFocusRow, 4, false);
            this.programTable.scrollRectToVisible(rectangle);
        }
        this.programTable.repaint();
        this.controlUnit.setState(false, nArray, "(Fetch cycle) MAR <-- PC");
        this.regPC.setState(true);
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 1;
        this.regMAR.setState(true);
        nArray[3] = 0;
        nArray[4] = 1;
        nArray[5] = 0;
        this.controlUnit.setState(true, nArray, "");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.memory.setState(false, true);
        this.regMAR.setValue(this.regPC.getValue());
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.regPC.setState(false);
        this.memory.setState(false, false);
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 0;
        nArray[7] = 0;
        this.controlUnit.setState(false, nArray, "");
        this.dataPathPanel.repaint();
        this.waitABit(this.delay);
        this.memory.setState(true, false);
        this.regMAR.setState(true);
        nArray[7] = 1;
        this.controlUnit.setState(false, nArray, "(Fetch Cycle) IR <-- M[MAR]");
        this.memory.setState(true, true);
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        this.regIR.setState(true);
        this.controlUnit.setState(true, nArray, "");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        int n3 = this.memoryArray[this.regMAR.getValue()];
        this.regIR.setValue(n3);
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.memory.setState(false, false);
        this.regMAR.setState(false);
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[7] = 0;
        this.regIR.setState(false);
        this.controlUnit.setState(false, nArray, "");
        this.dataPathPanel.repaint();
        this.waitABit(this.delay);
        this.regPC.setState(true);
        this.controlUnit.setState(false, nArray, "(Fetch Cycle) PC <-- PC + 1");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.regPC.setValue(this.regPC.getValue() + 1);
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.regPC.setState(false);
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        this.controlUnit.setState(false, nArray, " ");
        this.monitorPanel.repaint();
        this.regIR.setState(true);
        this.errorFound = false;
        if (this.fastFetch) {
            this.delay = n;
            this.briefDelay = n2;
            this.setSpeed.setEnabled(true);
        }
        this.setFastFetch.setEnabled(true);
        this.controlBar.repaint();
    }

    void jns() {
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.controlUnit.setState(false, nArray, "MBR <-- PC");
        nArray[0] = 0;
        nArray[1] = 1;
        nArray[2] = 1;
        this.regMBR.setState(true);
        nArray[3] = 0;
        nArray[4] = 1;
        nArray[5] = 0;
        this.regPC.setState(true);
        this.controlUnit.setState(true, nArray, "");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.memory.setState(false, true);
        this.regMBR.setValue(this.regPC.getValue());
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.memory.setState(false, false);
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        this.regMBR.setState(false);
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 0;
        this.regPC.setState(false);
        nArray[6] = 0;
        this.regAC.setState(false);
        this.controlUnit.setState(false, nArray, "(Decode IR[15-12])");
        this.waitABit(this.delay);
        this.dataPathPanel.repaint();
        this.controlUnit.setState(false, nArray, "MAR <-- IR[11-0]");
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        this.regIR.setState(true);
        this.regMAR.setState(true);
        this.memory.setState(false, true);
        this.controlUnit.setState(true, nArray, "");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.regMAR.setValue(this.regIR.getValue() & 0xFFF);
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.regIR.setState(false);
        this.memory.setState(false, false);
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 0;
        this.controlUnit.setState(false, nArray, "");
        this.regMAR.setState(false);
        this.waitABit(this.delay);
        this.dataPathPanel.repaint();
        nArray[4] = 1;
        nArray[5] = 1;
        this.regMBR.setState(true);
        nArray[7] = 1;
        this.regMAR.setState(true);
        this.controlUnit.setState(true, nArray, "M[MAR] <-- MBR");
        this.memory.setState(false, true);
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.memory.setState(true, true);
        this.memoryArray[this.regMAR.getValue()] = this.regMBR.getValue();
        this.dataPathPanel.repaint();
        this.waitABit(this.delay);
        this.regMAR.setState(false);
        nArray[7] = 0;
        this.memory.setState(false, false);
        nArray[0] = 0;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        this.regIR.setState(true);
        this.controlUnit.setState(true, nArray, "MBR <-- IR[11-0]");
        this.memory.setState(false, true);
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.regMBR.setValue(this.regIR.getValue() & 0xFFF);
        this.controlUnit.setState(false, nArray, "");
        this.regIR.setState(false);
        this.dataPathPanel.repaint();
        this.waitABit(this.delay);
        nArray[0] = 1;
        nArray[1] = 0;
        nArray[2] = 0;
        this.regAC.setState(true);
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 0;
        this.regMBR.setState(false);
        this.memory.setState(false, false);
        this.controlUnit.setState(true, nArray, "AC <-- 1");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.regAC.setValue(1);
        this.dataPathPanel.repaint();
        this.waitABit(this.delay);
        this.regMBR.setState(true);
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        this.controlUnit.setState(false, nArray, "AC <-- AC + MBR");
        nArray[8] = 1;
        nArray[9] = 1;
        this.aLU.setState(true);
        this.controlUnit.setState(false, nArray, "");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.regMBR.setState(false);
        nArray[9] = 0;
        this.regAC.setValue(this.regAC.getValue() + this.regMBR.getValue());
        this.controlUnit.setState(false, nArray, "");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.aLU.setState(false);
        nArray[8] = 0;
        this.controlUnit.setState(false, nArray, "");
        this.dataPathPanel.repaint();
        this.waitABit(this.delay);
        nArray[0] = 0;
        nArray[1] = 1;
        nArray[2] = 0;
        this.regPC.setState(true);
        nArray[3] = 1;
        nArray[4] = 0;
        nArray[5] = 0;
        this.memory.setState(false, true);
        this.controlUnit.setState(true, nArray, "PC <-- AC");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.regPC.setValue(this.regAC.getValue());
        this.regAC.setState(false);
        this.memory.setState(false, false);
        this.controlUnit.setState(false, nArray, "");
        this.dataPathPanel.repaint();
        this.waitABit(this.delay);
        this.regPC.setState(false);
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 0;
        this.controlUnit.setState(false, nArray, " ");
        this.dataPathPanel.repaint();
    }

    void load() {
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.regIR.setState(true);
        this.controlUnit.setState(false, nArray, "MAR <-- IR[11-0]");
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        this.regMAR.setState(true);
        this.controlUnit.setState(true, nArray, "");
        this.memory.setState(false, true);
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.regMAR.setValue(this.regIR.getValue() & 0xFFF);
        this.regIR.setState(false);
        this.memory.setState(false, false);
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 0;
        this.controlUnit.setState(false, nArray, "(Decode IR[15-12])");
        this.dataPathPanel.repaint();
        this.waitABit(this.delay);
        nArray[7] = 1;
        this.memory.setState(true, true);
        this.controlUnit.setState(false, nArray, "MBR <-- M[MAR]");
        nArray[2] = 1;
        nArray[1] = 1;
        this.regMBR.setState(true);
        this.controlUnit.setState(true, nArray, "");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        int n = this.memoryArray[this.regMAR.getValue()];
        this.regMBR.setValue(n);
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.memory.setState(false, false);
        this.regMAR.setState(false);
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[7] = 0;
        nArray[6] = 1;
        this.regAC.setState(true);
        this.controlUnit.setState(false, nArray, "AC <-- MBR");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.regAC.setValue(this.regMBR.getValue());
        this.dataPathPanel.repaint();
        this.waitABit(this.delay);
        this.regMBR.setState(false);
        this.regAC.setState(false);
        nArray[6] = 0;
        this.controlUnit.setState(false, nArray, " ");
        this.dataPathPanel.repaint();
    }

    void store() {
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.regIR.setState(true);
        this.controlUnit.setState(false, nArray, "MAR <-- IR[11-0]");
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        this.regMAR.setState(true);
        this.controlUnit.setState(true, nArray, "");
        this.memory.setState(false, true);
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.regMAR.setValue(this.regIR.getValue() & 0xFFF);
        this.regIR.setState(false);
        this.memory.setState(false, false);
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 0;
        this.controlUnit.setState(false, nArray, "(Decode IR[15-12])");
        this.regMAR.setState(false);
        this.waitABit(this.delay);
        this.dataPathPanel.repaint();
        this.regAC.setState(true);
        nArray[6] = 1;
        this.regMBR.setState(true);
        this.controlUnit.setState(false, nArray, " MBR <-- AC, M[MAR] <-- MBR");
        this.waitABit(this.delay);
        this.dataPathPanel.repaint();
        this.regMBR.setValue(this.regAC.getValue());
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        nArray[6] = 0;
        this.regAC.setState(false);
        this.controlUnit.setState(false, nArray, "");
        nArray[3] = 0;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[7] = 1;
        this.regMAR.setState(true);
        this.controlUnit.setState(true, nArray, "");
        this.memory.setState(true, true);
        this.memoryArray[this.regMAR.getValue()] = this.regMBR.getValue();
        this.dataPathPanel.repaint();
        this.waitABit(this.delay);
        this.regMBR.setState(false);
        this.regMAR.setState(false);
        this.memory.setState(false, false);
        nArray[4] = 0;
        nArray[5] = 0;
        nArray[7] = 0;
        this.controlUnit.setState(false, nArray, "  ");
        this.dataPathPanel.repaint();
    }

    void add() {
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.regIR.setState(true);
        this.controlUnit.setState(false, nArray, "MAR <-- IR[11-0]");
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        this.regMAR.setState(true);
        this.controlUnit.setState(true, nArray, "");
        this.memory.setState(false, true);
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.regMAR.setValue(this.regIR.getValue() & 0xFFF);
        this.controlUnit.setState(true, nArray, "(Decode IR[15-12])");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.regIR.setState(false);
        this.memory.setState(false, false);
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 0;
        nArray[7] = 1;
        this.controlUnit.setState(false, nArray, "");
        this.dataPathPanel.repaint();
        this.waitABit(this.delay);
        this.memory.setState(true, false);
        this.controlUnit.setState(false, nArray, "MBR <-- M[MAR]");
        this.memory.setState(true, true);
        nArray[1] = 1;
        nArray[2] = 1;
        this.regMBR.setState(true);
        this.controlUnit.setState(true, nArray, "");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.regMBR.setValue(this.memoryArray[this.regMAR.getValue()]);
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.memory.setState(false, false);
        this.regMAR.setState(false);
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[7] = 0;
        this.controlUnit.setState(false, nArray, "");
        this.dataPathPanel.repaint();
        this.waitABit(this.delay);
        nArray[8] = 1;
        nArray[9] = 1;
        this.aLU.setState(true);
        this.regAC.setState(true);
        this.controlUnit.setState(false, nArray, "AC <-- AC + MBR");
        this.regMBR.setState(false);
        nArray[9] = 0;
        this.regAC.setValue(this.regAC.getValue() + this.regMBR.getValue());
        this.controlUnit.setState(false, nArray, " ");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.aLU.setState(false);
        nArray[8] = 0;
        this.controlUnit.setState(false, nArray, " ");
        this.dataPathPanel.repaint();
        this.waitABit(this.delay);
        this.regAC.setState(false);
        this.controlUnit.setState(false, nArray, " ");
        this.dataPathPanel.repaint();
    }

    void subt() {
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.regIR.setState(true);
        this.controlUnit.setState(false, nArray, "MAR <-- IR[11-0]");
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        this.regMAR.setState(true);
        this.controlUnit.setState(true, nArray, "");
        this.memory.setState(false, true);
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.regMAR.setValue(this.memoryArray[this.regMAR.getValue()]);
        this.controlUnit.setState(false, nArray, "(Decode IR[15-12])");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.regIR.setState(false);
        this.memory.setState(false, false);
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 0;
        this.controlUnit.setState(false, nArray, "");
        this.dataPathPanel.repaint();
        this.waitABit(this.delay);
        this.memory.setState(true, false);
        nArray[7] = 1;
        this.controlUnit.setState(false, nArray, "MBR <-- M[MAR]");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.memory.setState(true, true);
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[7] = 0;
        this.regMBR.setState(true);
        this.controlUnit.setState(true, nArray, "");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.regMBR.setValue(this.memoryArray[this.regMAR.getValue()]);
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.memory.setState(false, false);
        this.regMAR.setState(false);
        nArray[1] = 0;
        nArray[2] = 0;
        this.controlUnit.setState(false, nArray, "");
        this.dataPathPanel.repaint();
        this.waitABit(this.delay);
        nArray[8] = 1;
        nArray[9] = 1;
        this.aLU.setState(true);
        this.regAC.setState(true);
        this.controlUnit.setState(false, nArray, "AC <-- AC - MBR");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.regAC.setValue(this.regAC.getValue() - this.regMBR.getValue());
        this.controlUnit.setState(false, nArray, " ");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.regMBR.setState(false);
        nArray[9] = 0;
        this.aLU.setState(false);
        nArray[8] = 0;
        this.controlUnit.setState(false, nArray, " ");
        this.dataPathPanel.repaint();
        this.waitABit(this.delay);
        this.regAC.setState(false);
        this.controlUnit.setState(false, nArray, " ");
        this.dataPathPanel.repaint();
    }

    void input() {
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.controlUnit.setState(false, nArray, "AC <-- InREG");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        if (this.machineState == 1) {
            this.setStatusMessage(" Waiting for input.");
            this.machineState = 2;
            this.inputContent.setText("");
            this.inputPanel.setBackground(Color.pink);
            this.inputBase.setBackground(Color.pink);
            this.inputContent.setEditable(true);
            this.inputContent.requestFocus();
            this.inputContent.repaint();
            nArray[0] = 1;
            nArray[1] = 0;
            nArray[2] = 0;
            nArray[3] = 1;
            nArray[4] = 0;
            nArray[5] = 1;
            this.controlUnit.setState(true, nArray, "(Decode IR[15-12])");
            this.dataPathPanel.repaint();
            this.waitABit(this.briefDelay);
            this.controlUnit.setState(false, nArray, "Waiting for input. . .");
            this.regINPUT.setState(true);
            this.regIR.setState(false);
            return;
        }
        if (this.machineState == 2) {
            this.regINPUT.setValue(this.stringToInt(this.regINPUT.getMode(), this.inputContent.getText()));
            this.inputContent.setEditable(false);
            this.runStop.requestFocus();
            this.inputPanel.setBackground(buttonPanelColor);
            this.inputBase.setBackground(buttonPanelColor);
            this.inputContent.setEditable(false);
            this.inputContent.repaint();
            if (this.fatalError) {
                this.halt();
                return;
            }
            nArray[0] = 1;
            nArray[1] = 0;
            nArray[2] = 0;
            nArray[3] = 1;
            nArray[4] = 0;
            nArray[5] = 1;
            this.regINPUT.setState(true);
            this.memory.setState(false, true);
            this.controlUnit.setState(false, nArray, "AC <-- InREG");
            this.regAC.setState(true);
            this.dataPathPanel.repaint();
            this.waitABit(this.briefDelay);
            this.regAC.setValue(this.regINPUT.getValue());
            this.dataPathPanel.repaint();
            this.waitABit(this.briefDelay);
            this.memory.setState(false, false);
            this.regINPUT.setState(false);
            this.regAC.setState(false);
            nArray[0] = 0;
            nArray[3] = 0;
            nArray[5] = 0;
            this.controlUnit.setState(false, nArray, " ");
            this.dataPathPanel.repaint();
            this.machineState = 1;
            if (this.stepping) {
                this.setStatusMessage(" Press [Step] to continue.");
                this.runStop.setText("Run");
            } else {
                this.setStatusMessage(" ");
            }
            this.runProgram();
        }
    }

    void output() {
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 0;
        nArray[3] = 1;
        nArray[4] = 0;
        nArray[5] = 1;
        this.controlUnit.setState(true, nArray, "OutREG <-- AC");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.controlUnit.setState(false, nArray, "(Decode IR[15-12])");
        this.regAC.setState(true);
        this.regOUTPUT.setState(true);
        this.regIR.setState(false);
        this.memory.setState(false, true);
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.controlUnit.setState(false, nArray, "");
        this.regOUTPUT.setValue(this.regAC.getValue());
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.memory.setState(false, false);
        this.regAC.setState(false);
        this.dataPathPanel.repaint();
        this.waitABit(this.delay);
        this.regOUTPUT.setState(false);
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[3] = 0;
        nArray[5] = 0;
        this.controlUnit.setState(false, nArray, " ");
        this.dataPathPanel.repaint();
    }

    void halt() {
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.controlUnit.setState(false, nArray, "(Decode IR[15-12])");
        this.runStop.setText("Run");
        this.regIR.setState(false);
        this.regOUTPUT.setState(false);
        this.regINPUT.setState(false);
        this.regAC.setState(false);
        this.regMBR.setState(false);
        this.regPC.setState(false);
        this.regMAR.setState(false);
        this.aLU.setState(false);
        this.memory.setState(false, false);
        this.controlUnit.setState(false, nArray, "");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.controlUnit.setState(false, nArray, "Halt");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        if (this.fatalError) {
            this.machineState = -1;
            this.controlUnit.setState(false, nArray, "Machine halted abnormally.");
            this.setStatusMessage(" Machine halted abnormally.");
        } else {
            this.machineState = 0;
            this.controlUnit.setState(false, nArray, "Machine halted normally.");
            this.setStatusMessage(" Machine halted normally.");
        }
        this.step.setEnabled(true);
        this.dataPathPanel.repaint();
    }

    void skipCond() {
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.regIR.setState(true);
        int n = this.regIR.getValue();
        n &= 0xC00;
        if ((n >>= 10) == 3) {
            this.fatalError = true;
            this.halt();
            return;
        }
        this.controlUnit.setState(false, nArray, "(Decode IR[15-12])");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        int n2 = this.regAC.getValue();
        switch (n) {
            case 0: {
                this.controlUnit.setState(true, nArray, "IR[11-10] = 00");
                this.dataPathPanel.repaint();
                this.waitABit(this.briefDelay);
                nArray[3] = 1;
                nArray[4] = 0;
                nArray[5] = 0;
                this.regIR.setState(false);
                this.regAC.setState(true);
                nArray[8] = 1;
                this.aLU.setState(true);
                this.controlUnit.setState(true, nArray, "AC < 0?");
                this.dataPathPanel.repaint();
                this.waitABit(this.briefDelay);
                if (n2 < 0) {
                    nArray[0] = 0;
                    nArray[1] = 1;
                    nArray[2] = 0;
                    this.regPC.setState(true);
                    nArray[3] = 0;
                    nArray[4] = 0;
                    nArray[5] = 0;
                    nArray[8] = 0;
                    this.regAC.setState(false);
                    this.aLU.setState(false);
                    this.controlUnit.setState(true, nArray, "PC <-- PC + 1");
                    this.dataPathPanel.repaint();
                    this.waitABit(this.briefDelay);
                    this.regPC.setValue(this.regPC.getValue() + 1);
                    break;
                }
                this.controlUnit.setState(true, nArray, "AC < 0?  FALSE!");
                break;
            }
            case 1: {
                this.controlUnit.setState(true, nArray, "IR[11-10] = 01");
                this.dataPathPanel.repaint();
                this.waitABit(this.briefDelay);
                nArray[3] = 1;
                nArray[4] = 0;
                nArray[5] = 0;
                this.regIR.setState(false);
                this.regAC.setState(true);
                nArray[8] = 1;
                this.aLU.setState(true);
                this.controlUnit.setState(true, nArray, "AC = 0?");
                this.dataPathPanel.repaint();
                this.waitABit(this.delay);
                if (n2 == 0) {
                    nArray[0] = 0;
                    nArray[1] = 1;
                    nArray[2] = 0;
                    this.regPC.setState(true);
                    nArray[3] = 0;
                    nArray[4] = 0;
                    nArray[5] = 0;
                    nArray[8] = 0;
                    this.regAC.setState(false);
                    this.aLU.setState(false);
                    this.controlUnit.setState(true, nArray, "PC <-- PC + 1");
                    this.dataPathPanel.repaint();
                    this.waitABit(this.briefDelay);
                    this.regPC.setValue(this.regPC.getValue() + 1);
                    break;
                }
                this.controlUnit.setState(true, nArray, "AC = 0?  FALSE!");
                break;
            }
            case 2: {
                this.controlUnit.setState(true, nArray, "IR[11-10] = 10");
                this.dataPathPanel.repaint();
                this.waitABit(this.briefDelay);
                nArray[3] = 1;
                nArray[4] = 0;
                nArray[5] = 0;
                this.regIR.setState(false);
                this.regAC.setState(true);
                nArray[8] = 1;
                this.aLU.setState(true);
                this.controlUnit.setState(true, nArray, "AC > 0?");
                this.dataPathPanel.repaint();
                this.waitABit(this.briefDelay);
                if (n2 > 0) {
                    nArray[0] = 0;
                    nArray[1] = 1;
                    nArray[2] = 0;
                    this.regPC.setState(true);
                    nArray[3] = 0;
                    nArray[4] = 0;
                    nArray[5] = 0;
                    nArray[8] = 0;
                    this.regAC.setState(false);
                    this.aLU.setState(false);
                    this.controlUnit.setState(true, nArray, "PC <-- PC + 1");
                    this.dataPathPanel.repaint();
                    this.waitABit(this.briefDelay);
                    this.regPC.setValue(this.regPC.getValue() + 1);
                    break;
                }
                this.controlUnit.setState(true, nArray, "AC > 0?  FALSE!");
            }
        }
        this.dataPathPanel.repaint();
        this.waitABit(this.delay);
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 0;
        nArray[8] = 0;
        this.regAC.setState(false);
        this.aLU.setState(false);
        this.regPC.setState(false);
        this.controlUnit.setState(false, nArray, " ");
        this.dataPathPanel.repaint();
    }

    void jump() {
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.controlUnit.setState(false, nArray, "(Decode IR[15-12])");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        nArray[0] = 0;
        nArray[1] = 1;
        nArray[2] = 0;
        this.regPC.setState(true);
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        this.controlUnit.setState(true, nArray, "PC <-- IR[11 - 0]");
        this.memory.setState(false, true);
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        int n = this.regIR.getValue();
        this.regPC.setValue(n &= 0xFFF);
        this.controlUnit.setState(false, nArray, "");
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 0;
        this.regIR.setState(false);
        this.regPC.setState(false);
        this.memory.setState(false, false);
        this.controlUnit.setState(false, nArray, " ");
        this.dataPathPanel.repaint();
    }

    void clear() {
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.controlUnit.setState(false, nArray, "(Decode IR[15-12])");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        nArray[0] = 1;
        nArray[1] = 0;
        nArray[2] = 0;
        this.controlUnit.setState(true, nArray, "AC <--- 0000");
        this.regAC.setState(true);
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.regAC.setValue(0);
        this.controlUnit.setState(false, nArray, "");
        this.dataPathPanel.repaint();
        this.waitABit(this.delay);
        this.regAC.setState(false);
        this.regIR.setState(false);
        nArray[0] = 0;
        this.controlUnit.setState(false, nArray, " ");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
    }

    void addI() {
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.regIR.setState(true);
        this.controlUnit.setState(false, nArray, "MAR <-- IR[11-0]");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        this.regMAR.setState(true);
        this.controlUnit.setState(true, nArray, "");
        this.memory.setState(false, true);
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        int n = this.regIR.getValue() & 0xFFF;
        this.regMAR.setValue(n);
        this.controlUnit.setState(false, nArray, "");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.regIR.setState(false);
        this.memory.setState(false, false);
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 0;
        this.controlUnit.setState(false, nArray, "(Decode IR[15-12])");
        this.dataPathPanel.repaint();
        this.waitABit(this.delay);
        nArray[7] = 1;
        this.controlUnit.setState(false, nArray, "MBR <-- M[MAR]");
        this.memory.setState(true, true);
        nArray[1] = 1;
        nArray[2] = 1;
        this.controlUnit.setState(true, nArray, "");
        this.regMBR.setState(true);
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        n = this.memoryArray[this.regMAR.getValue()];
        this.regMBR.setValue(n);
        this.dataPathPanel.repaint();
        this.waitABit(this.delay);
        this.memory.setState(false, true);
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 1;
        nArray[3] = 0;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[7] = 0;
        this.controlUnit.setState(true, nArray, "MAR <-- MBR");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.regMAR.setValue(this.regMBR.getValue());
        this.regMBR.setState(false);
        this.dataPathPanel.repaint();
        this.waitABit(this.delay);
        this.controlUnit.setState(false, nArray, "MBR <-- M[MAR]");
        this.memory.setState(true, true);
        nArray[0] = 0;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 0;
        nArray[7] = 1;
        this.controlUnit.setState(true, nArray, "");
        this.regMBR.setState(true);
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        int n2 = this.memoryArray[this.regMAR.getValue()];
        this.regMBR.setValue(n2);
        this.dataPathPanel.repaint();
        this.waitABit(this.delay);
        nArray[7] = 0;
        nArray[8] = 1;
        nArray[9] = 1;
        this.aLU.setState(true);
        this.regAC.setState(true);
        nArray[8] = 1;
        this.controlUnit.setState(false, nArray, "AC <-- AC + MBR");
        this.regMAR.setState(false);
        this.memory.setState(false, false);
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.regMBR.setState(false);
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[9] = 0;
        this.regAC.setValue(this.regAC.getValue() + this.regMBR.getValue());
        this.controlUnit.setState(false, nArray, " ");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.aLU.setState(false);
        nArray[8] = 0;
        this.controlUnit.setState(false, nArray, " ");
        this.dataPathPanel.repaint();
        this.waitABit(this.delay);
        this.regAC.setState(false);
        this.memory.setState(false, false);
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 0;
        this.controlUnit.setState(false, nArray, " ");
        this.dataPathPanel.repaint();
    }

    void jumpI() {
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.regIR.setState(true);
        this.controlUnit.setState(false, nArray, "MAR <-- IR[11-0]");
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        this.regMAR.setState(true);
        this.controlUnit.setState(true, nArray, "");
        this.memory.setState(false, true);
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        nArray[7] = 1;
        int n = this.regIR.getValue() & 0xFFF;
        this.regMAR.setValue(n);
        this.controlUnit.setState(true, nArray, "(Decode IR[15-12])");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.regIR.setState(false);
        this.memory.setState(false, false);
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 0;
        this.controlUnit.setState(false, nArray, "");
        this.dataPathPanel.repaint();
        this.waitABit(this.delay);
        this.controlUnit.setState(false, nArray, "MBR <-- M[MAR]");
        this.memory.setState(true, true);
        nArray[1] = 1;
        nArray[2] = 1;
        this.regMBR.setState(true);
        this.controlUnit.setState(true, nArray, "");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        n = this.memoryArray[this.regMAR.getValue()];
        this.regMBR.setValue(n);
        this.regMAR.setState(false);
        nArray[7] = 0;
        this.dataPathPanel.repaint();
        this.waitABit(this.delay);
        this.memory.setState(false, true);
        nArray[0] = 0;
        nArray[1] = 1;
        nArray[2] = 0;
        this.regPC.setState(true);
        nArray[3] = 0;
        nArray[4] = 1;
        nArray[5] = 1;
        this.controlUnit.setState(true, nArray, "PC <-- MBR");
        this.dataPathPanel.repaint();
        this.waitABit(this.briefDelay);
        this.regPC.setValue(this.regMBR.getValue());
        this.regMBR.setState(false);
        this.memory.setState(false, false);
        this.dataPathPanel.repaint();
        this.waitABit(this.delay);
        this.regPC.setState(false);
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 0;
        this.controlUnit.setState(false, nArray, " ");
        this.dataPathPanel.repaint();
    }

    void execute() {
        int n;
        String string = this.to4CharHexStr(this.regIR.getValue()).trim();
        try {
            n = Integer.parseInt(string.substring(0, 1), 16);
        }
        catch (NumberFormatException numberFormatException) {
            this.fatalError = true;
            this.errorCode = 1;
            return;
        }
        switch (n) {
            case 0: {
                this.jns();
                break;
            }
            case 1: {
                this.load();
                break;
            }
            case 2: {
                this.store();
                break;
            }
            case 3: {
                this.add();
                break;
            }
            case 4: {
                this.subt();
                break;
            }
            case 5: {
                this.input();
                break;
            }
            case 6: {
                this.output();
                break;
            }
            case 7: {
                this.halt();
                break;
            }
            case 8: {
                this.skipCond();
                break;
            }
            case 9: {
                this.jump();
                break;
            }
            case 10: {
                this.clear();
                break;
            }
            case 11: {
                this.addI();
                break;
            }
            case 12: {
                this.jumpI();
                break;
            }
            default: {
                this.fatalError = true;
                this.errorCode = 1;
            }
        }
    }

    void runProgram() {
        Runnable runnable = new Runnable(){

            public void run() {
                while (MarieDPath.this.machineState == 1 && !MarieDPath.this.fatalError) {
                    MarieDPath.this.fetch();
                    if (!MarieDPath.this.fatalError) {
                        MarieDPath.this.execute();
                        if (MarieDPath.this.stepping && MarieDPath.this.machineState == 1) {
                            MarieDPath.this.machineState = 3;
                            MarieDPath.this.setStatusMessage(" Press [Step] to continue.");
                            MarieDPath.this.runStop.setText("Run");
                            MarieDPath.this.stepping = false;
                        }
                    }
                    try {
                        Thread.sleep(MarieDPath.this.briefDelay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (MarieDPath.this.fatalError) {
                    MarieDPath.this.halt();
                }
            }
        };
        this.waitABit(100);
        this.setStatusMessage(" ");
        Thread thread = new Thread(runnable);
        thread.start();
    }

    void waitABit(int n) {
        if (this.machineState == 1) {
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        MarieDPath marieDPath = new MarieDPath();
        if (bl) {
            marieDPath.pack();
        } else {
            marieDPath.validate();
        }
        marieDPath.setVisible(true);
        marieDPath.repaint();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class DataPathPanel
    extends JPanel {
        DataPathPanel() {
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            super.paintComponent(graphics2D);
            MarieDPath.this.controlUnit.refresh(graphics);
            MarieDPath.this.regIR.refresh(graphics);
            MarieDPath.this.regOUTPUT.refresh(graphics);
            MarieDPath.this.regINPUT.refresh(graphics);
            MarieDPath.this.regAC.refresh(graphics);
            MarieDPath.this.regMBR.refresh(graphics);
            MarieDPath.this.regPC.refresh(graphics);
            MarieDPath.this.regMAR.refresh(graphics);
            MarieDPath.this.aLU.refresh(graphics);
            MarieDPath.this.memory.refresh(graphics);
        }
    }

    class MainMemory {
        boolean active = false;
        boolean busActive = false;

        void setState(boolean bl, boolean bl2) {
            this.active = bl;
            this.busActive = bl2;
        }

        void refresh(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.busActive) {
                graphics2D.setColor(busActiveColor);
            } else {
                graphics2D.setColor(busInactiveColor);
            }
            graphics2D.setStroke(MarieDPath.this.dataBus);
            graphics.drawLine(regOffset[7] + 27, 30, regOffset[7] + 27, 66);
            graphics.drawLine(regOffset[7] + 27, 30, regOffset[0], 30);
            graphics.drawLine(regOffset[6] + 27, 30, regOffset[6] + 27, 66);
            graphics.drawLine(regOffset[5] + 27, 30, regOffset[5] + 27, 66);
            graphics.drawLine(regOffset[4] + 27, 30, regOffset[4] + 27, 66);
            graphics.drawLine(regOffset[3] + 27, 30, regOffset[3] + 27, 66);
            graphics.drawLine(regOffset[2] + 27, 30, regOffset[2] + 27, 66);
            graphics.drawLine(regOffset[1] + 27, 30, regOffset[1] + 27, 66);
            if (this.active) {
                graphics2D.setColor(memoryActiveColor);
                graphics.fillRect(675, 15, 55, 170);
                graphics2D.setColor(componentLabelColor);
                graphics2D.setColor(componentOutlineColor);
                graphics2D.setStroke(MarieDPath.this.outline);
                graphics.drawRect(675, 15, 55, 170);
            } else {
                graphics2D.setColor(memoryInactiveColor);
                graphics.fillRect(675, 15, 55, 170);
            }
            graphics2D.setColor(componentLabelColor);
            graphics2D.setFont(new Font("sansserif", 1, 12));
            graphics2D.drawString("Main", 675, 200);
            graphics2D.drawString("Memory", 675, 215);
        }
    }

    class Register {
        int designation;
        short value;
        int mode;
        boolean active;

        public Register(int n) {
            this.designation = n > 0 && n <= 7 ? n : 0;
            this.value = 0;
            this.mode = 0;
            this.active = false;
        }

        void setValue(int n) {
            if (this.designation == 1 || this.designation == 2) {
                if (this.value < 0) {
                    n *= -1;
                }
                n &= 0xFFF;
            }
            this.value = (short)n;
            this.displayValues();
        }

        public void setValue(String string) {
            this.value = (short)MarieDPath.this.stringToInt(this.mode, string);
            if (!MarieDPath.this.errorFound) {
                this.setValue(this.value);
            } else {
                MarieDPath.this.fatalError = true;
                MarieDPath.this.errorCode = 7;
            }
        }

        public String toString() {
            String string = new String();
            switch (this.mode) {
                case 0: {
                    if (this.designation == 1 || this.designation == 2) {
                        string = "  " + MarieDPath.this.to3CharHexStr(this.value);
                        break;
                    }
                    string = " " + MarieDPath.this.to4CharHexStr(this.value);
                    break;
                }
                case 2: {
                    if (this.value == 0) {
                        string = null;
                        break;
                    }
                    string = "    " + (char)(this.value % 128);
                    break;
                }
                default: {
                    string = this.designation != 6 && this.value > 0 ? " " + Integer.toString(this.value) : Integer.toString(this.value);
                }
            }
            return string;
        }

        void setState(boolean bl) {
            this.active = bl;
        }

        void setMode(int n) {
            if (n >= 0 && n <= 2) {
                this.mode = n;
            }
        }

        int getMode() {
            return this.mode;
        }

        int getValue() {
            return this.value;
        }

        void displayValues() {
            if (MarieDPath.this.machineState == 1) {
                String string = " " + MarieDPath.this.to4CharHexStr(MarieDPath.this.regIR.getValue()) + "  " + MarieDPath.this.to4CharHexStr(MarieDPath.this.regOUTPUT.getValue()) + "  " + MarieDPath.this.to4CharHexStr(MarieDPath.this.regINPUT.getValue()) + "  " + MarieDPath.this.to4CharHexStr(MarieDPath.this.regAC.getValue()) + "  " + MarieDPath.this.to4CharHexStr(MarieDPath.this.regMBR.getValue()) + "  " + MarieDPath.this.to3CharHexStr(MarieDPath.this.regPC.getValue()) + "  " + MarieDPath.this.to3CharHexStr(MarieDPath.this.regMAR.getValue()) + linefeed;
                MarieDPath.this.traceTextArea.append(string);
                Document document = MarieDPath.this.traceTextArea.getDocument();
                MarieDPath.this.traceTextArea.select(document.getLength(), document.getLength());
            }
        }

        void refresh(Graphics graphics) {
            String string;
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n = 60;
            if (this.designation <= 2) {
                string = new String(MarieDPath.this.to3CharHexStr(this.value));
                n -= 8;
            } else {
                string = new String(MarieDPath.this.to4CharHexStr(this.value));
            }
            if (this.active) {
                graphics2D.setColor(regActiveColor);
                graphics2D.fillRect(regOffset[this.designation], 70, n, 25);
                graphics2D.setColor(componentOutlineColor);
                graphics2D.setStroke(MarieDPath.this.outline);
                graphics2D.drawRect(regOffset[this.designation], 70, n, 25);
                graphics2D.setFont(new Font("monospaced", 1, 14));
                graphics2D.setColor(regActiveFontColor);
            } else {
                graphics2D.setColor(regInactiveColor);
                graphics2D.fillRect(regOffset[this.designation], 70, n, 25);
                graphics2D.setFont(new Font("monospaced", 1, 14));
                graphics2D.setColor(regInactiveFontColor);
            }
            graphics2D.drawString(string, regOffset[this.designation] + 14, 87);
            graphics2D.setColor(componentLabelColor);
            graphics2D.setFont(new Font("sansserif", 1, 14));
            graphics2D.drawString(regName[this.designation], regOffset[this.designation], 111);
        }
    }

    class ALU
    extends Polygon {
        boolean active = false;

        public ALU() {
            super(aluXvals, aluYvals, 9);
        }

        void setState(boolean bl) {
            this.active = bl;
        }

        void refresh(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.active) {
                graphics2D.setColor(regActiveColor);
                graphics.fillPolygon(this);
                graphics2D.setColor(componentOutlineColor);
                graphics2D.setStroke(MarieDPath.this.outline);
                graphics.drawPolygon(this);
            } else {
                graphics2D.setColor(regInactiveColor);
                graphics.fillPolygon(this);
            }
            graphics2D.setColor(componentLabelColor);
            graphics2D.setFont(new Font("sansserif", 1, 14));
            graphics2D.drawString("ALU", 383, 147);
        }
    }

    class ControlUnit {
        boolean active = false;
        String microoperation;
        int[] controlVector = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

        public ControlUnit() {
            this.microoperation = new String();
        }

        void setState(boolean bl, int[] nArray, String string) {
            this.active = bl;
            if (string.length() > 0) {
                this.microoperation = string;
            }
            int n = 0;
            while (n < 10) {
                this.controlVector[n] = nArray[n];
                ++n;
            }
        }

        void refresh(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.active) {
                graphics2D.setColor(controllerActiveColor);
                graphics.fillRect(12, 35, 26, 142);
                graphics2D.setColor(componentOutlineColor);
                graphics.drawRect(12, 35, 26, 142);
            } else {
                graphics2D.setColor(controllerInactiveColor);
                graphics.fillRect(12, 35, 26, 142);
            }
            graphics2D.setColor(componentLabelColor);
            graphics2D.setFont(new Font("sansserif", 1, 10));
            graphics2D.drawString("Write", 42, 42);
            graphics2D.drawString("Read", 42, 156);
            graphics2D.setFont(new Font("sansserif", 1, 12));
            graphics2D.drawString("Control", 12, 192);
            graphics2D.drawString("Unit", 12, 207);
            graphics2D.setStroke(MarieDPath.this.controlLine);
            int n = 0;
            while (n < 10) {
                if (this.controlVector[n] == 0) {
                    graphics2D.setColor(controlLineInactiveColor);
                } else {
                    graphics2D.setColor(controlLineActiveColor);
                }
                switch (n) {
                    case 0: {
                        graphics.drawLine(39, 46, 675, 46);
                        int n2 = 1;
                        while (n2 <= 7) {
                            graphics.drawLine(regOffset[n2] + 5, 46, regOffset[n2] + 5, 70);
                            ++n2;
                        }
                        break;
                    }
                    case 1: {
                        graphics.drawLine(39, 50, 675, 50);
                        int n3 = 1;
                        while (n3 <= 7) {
                            graphics.drawLine(regOffset[n3] + 10, 50, regOffset[n3] + 10, 70);
                            ++n3;
                        }
                        break;
                    }
                    case 2: {
                        graphics.drawLine(39, 54, 675, 54);
                        int n4 = 1;
                        while (n4 <= 7) {
                            graphics.drawLine(regOffset[n4] + 15, 54, regOffset[n4] + 15, 70);
                            ++n4;
                        }
                        break;
                    }
                    case 3: {
                        graphics.drawLine(39, 160, 675, 160);
                        int n5 = 1;
                        while (n5 <= 7) {
                            graphics.drawLine(regOffset[n5] + 37, 95, regOffset[n5] + 37, 160);
                            ++n5;
                        }
                        break;
                    }
                    case 4: {
                        graphics.drawLine(39, 164, 675, 164);
                        int n6 = 1;
                        while (n6 <= 7) {
                            graphics.drawLine(regOffset[n6] + 42, 95, regOffset[n6] + 42, 164);
                            ++n6;
                        }
                        break;
                    }
                    case 5: {
                        graphics.drawLine(39, 168, 675, 168);
                        int n7 = 1;
                        while (n7 <= 7) {
                            graphics.drawLine(regOffset[n7] + 47, 95, regOffset[n7] + 47, 168);
                            ++n7;
                        }
                        break;
                    }
                    case 6: {
                        graphics.drawLine(regOffset[4] + 60, 78, regOffset[3], 78);
                        break;
                    }
                    case 7: {
                        graphics.drawLine(regOffset[1] + 60 - 7, 82, regOffset[0], 82);
                        break;
                    }
                    case 8: {
                        graphics.drawLine(regOffset[4] + 60, 88, aluXvals[0] + 10, 88);
                        graphics.drawLine(aluXvals[0] + 10, 88, aluXvals[0] + 10, aluYvals[0]);
                        break;
                    }
                    case 9: {
                        graphics.drawLine(aluXvals[4] + 10, aluYvals[4], aluXvals[4] + 10, 88);
                        graphics.drawLine(aluXvals[4] + 10, 88, regOffset[3], 88);
                    }
                }
                ++n;
            }
            graphics2D.setColor(rTLFontColor);
            graphics2D.setFont(new Font("monospaced", 1, 16));
            if (this.microoperation.length() > 0) {
                graphics2D.drawString(this.microoperation, 340 - this.microoperation.length() * 4, 200);
            } else {
                graphics2D.drawString(" ", 310, 200);
            }
        }
    }

    class ProgramTableModel
    extends AbstractTableModel {
        String[] headers = new String[]{" ", "label", "opcode", "operand", "hex"};

        ProgramTableModel() {
        }

        public int getColumnCount() {
            return this.headers.length;
        }

        public int getRowCount() {
            return MarieDPath.this.codeLineCount;
        }

        public String getColumnName(int n) {
            return this.headers[n];
        }

        public Object getValueAt(int n, int n2) {
            return MarieDPath.this.programArray[n][n2];
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    class MarieExecutableFileFilter
    extends FileFilter {
        String myFileType = ".mex";

        MarieExecutableFileFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().endsWith(this.myFileType);
        }

        public String getDescription() {
            return "*" + this.myFileType;
        }
    }

    public class HelpAboutFrame
    extends JDialog
    implements ActionListener {
        JPanel mainPanel = new JPanel();
        JPanel centerPanel = new JPanel();
        JPanel logoPanel = new JPanel();
        JLabel logoLabel = new JLabel();
        ImageIcon logo = new ImageIcon();
        JPanel infoPanel = new JPanel();
        JLabel pgmTitle = new JLabel("MARIE DataPath Simulator - Version 1.0");
        JLabel copyRight = new JLabel("Copyright (c) 2003, 2006");
        JLabel accompany = new JLabel("To accompany:");
        JLabel theBook = new JLabel("The Essentials of Computer Organization and Architecture 2/e  ");
        JLabel authors = new JLabel("By Linda M. Null & Julia M. Lobur");
        JLabel publisher = new JLabel("Jones & Bartlett Publishers");
        JPanel okBttonPanel = new JPanel();
        JButton okButton = new JButton("Ok");
        GridLayout gridLayout = new GridLayout();

        public HelpAboutFrame(Frame frame) {
            super(frame);
            this.setTitle("About this Program");
            this.enableEvents(64L);
            this.mainPanel.setLayout(new BorderLayout());
            this.logo = new ImageIcon((class$MarieSimulator$MarieDPath == null ? (class$MarieSimulator$MarieDPath = MarieDPath.class$("MarieSimulator.MarieDPath")) : class$MarieSimulator$MarieDPath).getResource("ECOA.jpg"));
            this.logoPanel.setLayout(new FlowLayout());
            this.logoPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.logoLabel.setIcon(this.logo);
            this.logoPanel.add((Component)this.logoLabel, null);
            this.centerPanel.setLayout(new BorderLayout());
            this.centerPanel.add((Component)this.logoPanel, "West");
            this.copyRight.setFont(new Font("sanserif", 0, 12));
            this.accompany.setFont(new Font("sanserif", 0, 12));
            this.theBook.setFont(new Font("sanserif", 3, 14));
            this.authors.setFont(new Font("sanserif", 0, 12));
            this.publisher.setFont(new Font("sanserif", 0, 12));
            this.infoPanel.setLayout(this.gridLayout);
            this.gridLayout.setRows(6);
            this.gridLayout.setColumns(1);
            this.infoPanel.setBorder(BorderFactory.createEmptyBorder(10, 60, 10, 10));
            this.okBttonPanel.setLayout(new FlowLayout());
            this.okButton.addActionListener(this);
            this.getContentPane().add((Component)this.mainPanel, null);
            this.infoPanel.add((Component)this.pgmTitle, null);
            this.infoPanel.add((Component)this.copyRight, null);
            this.infoPanel.add((Component)this.accompany, null);
            this.infoPanel.add((Component)this.theBook, null);
            this.infoPanel.add((Component)this.authors, null);
            this.infoPanel.add((Component)this.publisher, null);
            this.centerPanel.add((Component)this.infoPanel, "Center");
            this.mainPanel.add((Component)this.centerPanel, "North");
            this.okBttonPanel.add((Component)this.okButton, null);
            this.mainPanel.add((Component)this.okBttonPanel, "South");
            this.setResizable(true);
            this.setLocation(75, 75);
            this.setModal(true);
            this.pack();
            this.show();
        }

        protected void processWindowEvent(WindowEvent windowEvent) {
            if (windowEvent.getID() == 201) {
                this.cancel();
            }
            super.processWindowEvent(windowEvent);
        }

        void cancel() {
            this.dispose();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.okButton) {
                this.cancel();
            }
        }
    }

    class DelayFrame
    extends JFrame {
        JPanel buttons = new JPanel();
        JLabel sliderLabel = new JLabel("Select instruction execution delay in milliseconds.");
        JTextField msDelay = new JTextField();
        JLabel blankLabel = new JLabel();
        JButton okayButton = new JButton("Okay");
        JButton cancelButton = new JButton("Cancel");
        int sliderDelay;

        DelayFrame() {
            super("Set Delay");
            this.sliderDelay = MarieDPath.this.delay;
            JPanel jPanel = (JPanel)this.getContentPane();
            this.setSize(new Dimension(400, 200));
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ DelayFrame this$1;
                {
                    this.this$1 = delayFrame;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    this.this$1.dispose();
                }
            });
            jPanel.setPreferredSize(new Dimension(350, 150));
            jPanel.setLayout(new FlowLayout());
            this.setIconImage(Toolkit.getDefaultToolkit().createImage((class$MarieSimulator$MarieSim == null ? (class$MarieSimulator$MarieSim = MarieDPath.class$("MarieSimulator.MarieSim")) : class$MarieSimulator$MarieSim).getResource("M.gif")));
            MarieDPath.this.setStatusMessage(" Execution delay set at " + MarieDPath.this.delay + " milliseconds.");
            this.sliderLabel.setPreferredSize(new Dimension(300, 50));
            this.sliderLabel.setForeground(Color.black);
            JSlider jSlider = new JSlider(0, 0, 30000, MarieDPath.this.delay);
            jSlider.setMajorTickSpacing(10000);
            jSlider.setMinorTickSpacing(2500);
            jSlider.setPaintTicks(true);
            jSlider.setPaintLabels(true);
            jSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            jSlider.setPreferredSize(new Dimension(325, 50));
            jSlider.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ DelayFrame this$1;
                {
                    this.this$1 = delayFrame;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    if (!jSlider.getValueIsAdjusting()) {
                        this.this$1.sliderDelay = jSlider.getValue();
                        this.this$1.msDelay.setText(" " + this.this$1.sliderDelay);
                        this.this$1.msDelay.postActionEvent();
                    }
                }
            });
            this.msDelay.setPreferredSize(new Dimension(57, 30));
            this.msDelay.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(145, 145, 210), 2), BorderFactory.createLoweredBevelBorder()));
            this.msDelay.setFont(new Font("Monospaced", 0, 14));
            this.msDelay.setText(" " + MarieDPath.this.delay);
            this.msDelay.setEditable(false);
            this.blankLabel.setPreferredSize(new Dimension(30, 35));
            this.okayButton.setMaximumSize(new Dimension(80, 35));
            this.okayButton.setMinimumSize(new Dimension(80, 35));
            this.okayButton.setPreferredSize(new Dimension(80, 35));
            JRootPane jRootPane = this.getRootPane();
            jRootPane.setDefaultButton(this.okayButton);
            this.okayButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ DelayFrame this$1;
                {
                    this.this$1 = delayFrame;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.this$1.sliderDelay < 10) {
                        this.this$1.sliderDelay = 10;
                    }
                    DelayFrame.access$000((DelayFrame)this.this$1).delay = this.this$1.sliderDelay;
                    DelayFrame.access$000((DelayFrame)this.this$1).briefDelay = DelayFrame.access$000((DelayFrame)this.this$1).delay / 2;
                    DelayFrame.access$000(this.this$1).setStatusMessage(" Execution delay set at " + DelayFrame.access$000((DelayFrame)this.this$1).delay + " milliseconds.");
                    WindowEvent windowEvent = new WindowEvent(this.this$1, 201);
                    this.this$1.dispatchEvent(windowEvent);
                }
            });
            this.cancelButton.setMaximumSize(new Dimension(80, 35));
            this.cancelButton.setMinimumSize(new Dimension(80, 35));
            this.cancelButton.setPreferredSize(new Dimension(80, 35));
            this.cancelButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ DelayFrame this$1;
                {
                    this.this$1 = delayFrame;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    WindowEvent windowEvent = new WindowEvent(this.this$1, 201);
                    this.this$1.dispatchEvent(windowEvent);
                }
            });
            this.buttons.setPreferredSize(new Dimension(300, 75));
            this.buttons.add(this.msDelay);
            this.buttons.add(this.blankLabel);
            this.buttons.add(this.okayButton);
            this.buttons.add(this.cancelButton);
            jPanel.add(this.sliderLabel);
            jPanel.add(jSlider);
            jPanel.add(this.buttons);
            this.setLocation(200, 75);
            this.show();
        }

        static /* synthetic */ MarieDPath access$000(DelayFrame delayFrame) {
            return delayFrame.MarieDPath.this;
        }
    }
}

