/*
 * Decompiled with CFR 0.152.
 */
package MarieSimulator;

import MarieSimulator.AssembledCodeLine;
import MarieSimulator.MarieEditor;
import MarieSimulator.MarieSim;
import MarieSimulator.TextFileViewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.Document;

public class MarieSim
extends JFrame {
    public static String mexFile = null;
    public static String mexPath = null;
    public static final String MEX_TYPE = ".mex";
    public static final String MAP_TYPE = ".map";
    public static final String SRC_TYPE = ".mas";
    public static final String DMP_TYPE = ".dmp";
    public static final String linefeed = System.getProperty("line.separator");
    public static final String formfeed = "\f";
    public static final String fileSeparator = System.getProperty("file.separator");
    public static final String HELP_FILE = "msimhlp1.txt";
    public static final JFileChooser exeFileChooser = new JFileChooser(System.getProperty("user.dir"));
    public static final String[] errorMsgs = new String[]{"Program terminated normally.", "Illegal opcode", "Illegal conditional operand", "Address out of range", "Invalid machine code format", "IO Exception on input file", "Invalid register", "Illegal numeric value in register", "Maximum program statements reached"};
    public static final boolean[] operandReqd = new boolean[]{true, true, true, true, true, false, false, false, false, false, false, true, true};
    public static final int MAX_MARIE_INT = Short.MAX_VALUE;
    public static final int MIN_MARIE_INT = Short.MIN_VALUE;
    public static final int MAX_MARIE_ADDR = 4095;
    public static final int HEX = 0;
    public static final int DEC = 1;
    public static final int ASCII = 2;
    public static final int MARIE_HALTED_NORMAL = 0;
    public static final int MARIE_RUNNING = 1;
    public static final int MARIE_BLOCKED_ON_INPUT = 2;
    public static final int MARIE_PAUSED = 3;
    public static final int MARIE_HALTED_ABNORMAL = -1;
    public static final int MARIE_HALTED_BY_USER = -2;
    public static final int MARIE_NO_PROGRAM_LOADED = -3;
    public static final int MARIE_UNINITIALIZED = 57005;
    public static final int AC = 0;
    public static final int IR = 1;
    public static final int MAR = 2;
    public static final int MBR = 3;
    public static final int PC = 4;
    public static final int INPUT = 5;
    public static final int OUTPUT = 6;
    static final int MEMORY_TABLE_ROW_HEIGHT = 15;
    static final int PROGRAM_TABLE_ROW_HEIGHT = 19;
    public static final int MINIMUM_DELAY = 10;
    public static final String[] base = new String[]{"Hex", "Dec", "ASCII"};
    public static final String[] outputControl = new String[]{"Control", "Use Linefeeds", "No Linefeeds", "Clear output", "Print"};
    public static final Color simulatorBackground = new Color(175, 175, 200);
    public static final Color registerForeground = new Color(105, 185, 225);
    public static final Color registerBackground = new Color(105, 165, 200);
    public static final Color registerTextColor = new Color(85, 55, 155);
    public static final Color messageBackground = new Color(210, 210, 255);
    public static final Color tableHeaderColor = new Color(65, 80, 150);
    int instructionCode = 0;
    int codeLineCount = 0;
    boolean stepping = false;
    boolean breakpointOn = false;
    int delay = 10;
    boolean outputWithLinefeed = true;
    static String statusMessage = null;
    static Vector outputStream = new Vector();
    int machineState = 57005;
    boolean errorFound = false;
    boolean fatalError = false;
    int errorCode = 0;
    JPanel simulatorPane;
    JMenuBar controlBar = new JMenuBar();
    JMenu fileMenu = new JMenu();
    JMenuItem loadFileItem = new JMenuItem();
    JMenuItem editFileItem = new JMenuItem();
    MarieEditor marieEditor;
    JMenuItem reloadFileItem = new JMenuItem();
    JMenuItem exitFileItem = new JMenuItem();
    JMenu runMenu = new JMenu();
    JMenuItem runRunItem = new JMenuItem();
    JMenu stepRunMenu = new JMenu();
    JMenuItem stepRunOn = new JMenuItem();
    JMenuItem stepRunOff = new JMenuItem();
    JMenuItem setDelay = new JMenuItem();
    DelayFrame delayFrame;
    JMenuItem restartItem = new JMenuItem();
    JMenuItem resetItem = new JMenuItem();
    JMenuItem getDump = new JMenuItem();
    CoreDumpFrame dumpFrame;
    TextFileViewer dumpViewer;
    JButton runStop = new JButton();
    JButton step = new JButton();
    JMenu breakpointMenu = new JMenu();
    JMenuItem runToItem = new JMenuItem();
    JMenuItem clearBPointsItem = new JMenuItem();
    JButton showSymbols = new JButton();
    TextFileViewer symbolTable;
    JMenu helpMenu = new JMenu();
    JMenuItem getHelp = new JMenuItem();
    TextFileViewer helpViewer;
    JMenuItem helpAbout = new JMenuItem();
    HelpAboutFrame helpAboutFrame;
    JPanel mainPanel = new JPanel();
    Object[][] programArray;
    JScrollPane programPane = new JScrollPane();
    JTable programTable;
    ProgramTableModel ptm = new ProgramTableModel();
    int programFocusRow = 0;
    Hashtable codeReference = new Hashtable(16, 0.75f);
    JPanel registersPanel = new JPanel();
    JPanel acPanel = new JPanel();
    Register regAC = new Register(0);
    JLabel acLabel = new JLabel();
    JComboBox acModeBox = new JComboBox<String>(base);
    JPanel irPanel = new JPanel();
    Register regIR = new Register(1);
    JLabel irLabel = new JLabel();
    JComboBox irModeBox = new JComboBox<String>(base);
    JPanel marPanel = new JPanel();
    Register regMAR = new Register(2);
    JLabel marLabel = new JLabel();
    JComboBox marModeBox = new JComboBox<String>(base);
    JPanel mbrPanel = new JPanel();
    Register regMBR = new Register(3);
    JLabel mbrLabel = new JLabel();
    JComboBox mbrModeBox = new JComboBox<String>(base);
    JPanel pcPanel = new JPanel();
    Register regPC = new Register(4);
    JLabel pcLabel = new JLabel();
    JComboBox pcModeBox = new JComboBox<String>(base);
    JPanel inputPanel = new JPanel();
    Register regINPUT = new Register(5);
    JLabel inputLabel = new JLabel();
    JComboBox inputModeBox = new JComboBox<String>(base);
    JPanel outputOuterPanel = new JPanel();
    JPanel outputInnerPanel = new JPanel();
    TitledBorder outputInnerBorder = new TitledBorder(BorderFactory.createRaisedBevelBorder(), "OUTPUT", 2, 3);
    Register regOUTPUT = new Register(6);
    JScrollPane outputScrollPane = new JScrollPane();
    JTextArea outputArea = new JTextArea();
    JComboBox outputModeBox = new JComboBox<String>(base);
    JComboBox outputControlBox = new JComboBox<String>(outputControl);
    JScrollPane memoryPane = new JScrollPane();
    Object[][] memoryArray = new Object[256][17];
    JTable memoryTable;
    int memoryFocusCell = 0;
    JTextField msgField = new JTextField();
    JPanel bottomPanel = new JPanel();
    static /* synthetic */ Class class$MarieSimulator$MarieSim;
    static /* synthetic */ Class class$MarieSimulator$MarieDPath;
    static /* synthetic */ Class class$java$lang$Object;

    public MarieSim() {
        this.setSize(new Dimension(780, 550));
        this.setIconImage(Toolkit.getDefaultToolkit().createImage((class$MarieSimulator$MarieSim == null ? (class$MarieSimulator$MarieSim = MarieSim.class$("MarieSimulator.MarieSim")) : class$MarieSimulator$MarieSim).getResource("M.gif")));
        this.setTitle("MARIE Simulator");
        this.enableEvents(64L);
        this.simulatorPane = (JPanel)this.getContentPane();
        this.simulatorPane.setLayout(new FlowLayout());
        this.simulatorPane.setBackground(simulatorBackground);
        this.simulatorPane.setBorder(BorderFactory.createLineBorder(Color.black));
        this.fileMenu.setText("File");
        this.fileMenu.setMnemonic('F');
        this.fileMenu.setToolTipText("Start here!");
        exeFileChooser.addChoosableFileFilter(new MarieExecutableFileFilter());
        exeFileChooser.removeChoosableFileFilter(exeFileChooser.getAcceptAllFileFilter());
        this.loadFileItem.setText("Load");
        this.loadFileItem.setMnemonic('L');
        this.loadFileItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieSim.this.fileMenu.setToolTipText("Load, edit file or quit.");
                MarieSim.this.getProgram();
            }
        });
        this.editFileItem.setText("Edit");
        this.editFileItem.setMnemonic('E');
        this.editFileItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieSim.this.displayEditorFrame();
            }
        });
        this.reloadFileItem.setText("Reload");
        this.reloadFileItem.setMnemonic('D');
        this.reloadFileItem.setEnabled(false);
        this.reloadFileItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieSim.this.loadProgram();
            }
        });
        this.exitFileItem.setText("Exit");
        this.exitFileItem.setMnemonic('X');
        this.exitFileItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieSim.this.exitProgram();
            }
        });
        this.fileMenu.add(this.loadFileItem);
        this.fileMenu.add(this.editFileItem);
        this.fileMenu.add(this.reloadFileItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitFileItem);
        this.runMenu.setText("Run");
        this.runMenu.setMnemonic('R');
        this.runMenu.setToolTipText("Run, Stepping, Delay, Restart, Reset, and Core Dump.");
        this.runRunItem.setText("Run");
        this.runRunItem.setMnemonic('R');
        this.runRunItem.setEnabled(false);
        this.runRunItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieSim.this.restartItem.setEnabled(true);
                if (MarieSim.this.machineState != 2) {
                    MarieSim.this.stepping = false;
                    MarieSim.this.step.setEnabled(false);
                    MarieSim.this.stepRunOff.setEnabled(false);
                    MarieSim.this.stepRunOn.setEnabled(true);
                    MarieSim.this.repaint();
                    MarieSim.this.runStop.setEnabled(true);
                    if (MarieSim.this.machineState == 0 || MarieSim.this.machineState == 3 || MarieSim.this.machineState == -1) {
                        MarieSim.this.restart();
                    }
                    MarieSim.this.runProgram();
                }
            }
        });
        this.stepRunMenu.setText("Set Stepping mode");
        this.stepRunMenu.setMnemonic('S');
        this.stepRunOn.setText("On");
        this.stepRunOn.setMnemonic('N');
        this.stepRunOn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieSim.this.setStatusMessage(" Press [Step] to start.");
                MarieSim.this.stepping = true;
                MarieSim.this.stepRunOff.setEnabled(true);
                MarieSim.this.stepRunOn.setEnabled(false);
                MarieSim.this.step.setEnabled(true);
            }
        });
        this.stepRunOff.setText("Off");
        this.stepRunOff.setEnabled(false);
        this.stepRunOff.setMnemonic('F');
        this.stepRunOff.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieSim.this.setStatusMessage(" ");
                MarieSim.this.stepping = false;
                MarieSim.this.stepRunOff.setEnabled(false);
                MarieSim.this.stepRunOn.setEnabled(true);
                MarieSim.this.step.setEnabled(false);
            }
        });
        this.setDelay.setText("Set Delay");
        this.setDelay.setEnabled(true);
        this.setDelay.setMnemonic('D');
        this.setDelay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieSim.this.displayDelayFrame();
            }
        });
        this.restartItem.setText("Restart");
        this.restartItem.setEnabled(false);
        this.restartItem.setMnemonic('E');
        this.restartItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieSim.this.restart();
            }
        });
        this.resetItem.setText("Reset Simulator");
        this.resetItem.setMnemonic('S');
        this.resetItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieSim.this.confirmReset();
            }
        });
        this.getDump.setText("Core Dump");
        this.getDump.setEnabled(false);
        this.getDump.setMnemonic('D');
        this.getDump.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieSim.this.displayCoreDump();
            }
        });
        this.runMenu.add(this.runRunItem);
        this.stepRunMenu.add(this.stepRunOn);
        this.stepRunMenu.add(this.stepRunOff);
        this.runMenu.add(this.stepRunMenu);
        this.runMenu.add(this.setDelay);
        this.runMenu.addSeparator();
        this.runMenu.add(this.restartItem);
        this.runMenu.add(this.resetItem);
        this.runMenu.add(this.getDump);
        this.runStop.setText("Stop");
        this.runStop.setMnemonic('S');
        this.runStop.setEnabled(false);
        this.runStop.setMaximumSize(new Dimension(70, 27));
        this.runStop.setMinimumSize(new Dimension(70, 27));
        this.runStop.setPreferredSize(new Dimension(70, 27));
        this.runStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieSim.this.runStop.setEnabled(false);
                MarieSim.this.machineState = -2;
                MarieSim.this.setStatusMessage(" Halted at user request.");
            }
        });
        this.step.setText("Step");
        this.step.setMnemonic('T');
        this.step.setEnabled(false);
        this.step.setMaximumSize(new Dimension(70, 27));
        this.step.setMinimumSize(new Dimension(70, 27));
        this.step.setPreferredSize(new Dimension(70, 27));
        this.step.setFocusPainted(false);
        this.step.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieSim.this.restartItem.setEnabled(true);
                if (MarieSim.this.machineState != 2 && !MarieSim.this.fatalError) {
                    MarieSim.this.setStatusMessage(" Press [Step] to continue.");
                    MarieSim.this.fetchNext();
                    MarieSim.this.execute();
                }
            }
        });
        this.breakpointMenu.setText("Breakpoints");
        this.breakpointMenu.setToolTipText("Run and reset.");
        this.breakpointMenu.setMnemonic('B');
        this.breakpointMenu.setEnabled(false);
        this.runToItem.setText("Run to Breakpoint");
        this.runToItem.setMnemonic('R');
        this.runToItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieSim.this.restartItem.setEnabled(true);
                if (MarieSim.this.machineState != 2 && !MarieSim.this.fatalError) {
                    MarieSim.this.runStop.setEnabled(true);
                    MarieSim.this.controlBar.repaint();
                    MarieSim.this.runToBreakpoint();
                    MarieSim.this.runStop.setEnabled(false);
                }
            }
        });
        this.clearBPointsItem.setText("Clear Breakpoints");
        this.clearBPointsItem.setMnemonic('C');
        this.clearBPointsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieSim.this.clearBreakPoints();
            }
        });
        this.breakpointMenu.add(this.runToItem);
        this.breakpointMenu.add(this.clearBPointsItem);
        this.showSymbols.setText("Symbol Map");
        this.showSymbols.setMnemonic('M');
        this.showSymbols.setMaximumSize(new Dimension(120, 27));
        this.showSymbols.setMinimumSize(new Dimension(120, 27));
        this.showSymbols.setPreferredSize(new Dimension(120, 27));
        this.showSymbols.setFocusPainted(false);
        this.showSymbols.setEnabled(false);
        this.showSymbols.setToolTipText("Display symbol table.");
        this.showSymbols.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieSim.this.displaySymbolTable();
            }
        });
        this.getHelp.setText("Help");
        this.getHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieSim.this.displayHelpFrame();
            }
        });
        this.helpMenu.setText("Help");
        this.helpAbout.setText("About");
        this.helpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieSim.this.displayHelpAboutFrame();
            }
        });
        this.helpMenu.add(this.getHelp);
        this.helpMenu.add(this.helpAbout);
        this.controlBar.add(this.fileMenu);
        this.controlBar.add(this.runMenu);
        this.controlBar.add(this.runStop);
        this.controlBar.add(this.step);
        this.controlBar.add(this.breakpointMenu);
        this.controlBar.add(this.showSymbols);
        this.controlBar.add(this.helpMenu);
        this.setJMenuBar(this.controlBar);
        this.mainPanel.setPreferredSize(new Dimension(760, 270));
        this.mainPanel.setLayout(new FlowLayout());
        this.mainPanel.setBorder(BorderFactory.createLineBorder(simulatorBackground, 4));
        this.mainPanel.setBackground(simulatorBackground);
        this.programPane = this.createProgramPanel();
        this.programPane.setPreferredSize(new Dimension(318, 248));
        this.programPane.setBorder(BorderFactory.createEtchedBorder());
        this.mainPanel.add(this.programPane);
        this.registersPanel.setBackground(registerBackground);
        this.registersPanel.setBorder(BorderFactory.createEtchedBorder());
        this.registersPanel.setPreferredSize(new Dimension(194, 250));
        this.registersPanel.setLayout(new FlowLayout());
        this.acPanel.setPreferredSize(new Dimension(172, 35));
        this.acPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.acPanel.setBackground(registerForeground);
        this.acPanel.setLayout(new FlowLayout());
        this.acLabel.setPreferredSize(new Dimension(30, 15));
        this.acLabel.setFont(new Font("Dialog", 1, 12));
        this.acLabel.setText("AC");
        this.acLabel.setForeground(registerTextColor);
        this.acLabel.setToolTipText("Accumulator");
        this.regAC.setPreferredSize(new Dimension(52, 20));
        this.regAC.setBorder(BorderFactory.createLoweredBevelBorder());
        this.regAC.setFont(new Font("Monospaced", 0, 14));
        this.regAC.setValue(0);
        this.regAC.setEditable(false);
        this.acModeBox.setPreferredSize(new Dimension(57, 20));
        this.acModeBox.setBackground(registerForeground);
        this.acModeBox.setFont(new Font("Dialog", 0, 11));
        this.acModeBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = MarieSim.this.acModeBox.getSelectedIndex();
                MarieSim.this.regAC.setMode(n);
            }
        });
        this.acPanel.add(this.acLabel);
        this.acPanel.add(this.regAC);
        this.acPanel.add(this.acModeBox);
        this.registersPanel.add(this.acPanel);
        this.irPanel.setPreferredSize(new Dimension(172, 34));
        this.irPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.irPanel.setBackground(registerForeground);
        this.irPanel.setLayout(new FlowLayout());
        this.irLabel.setPreferredSize(new Dimension(30, 15));
        this.irLabel.setFont(new Font("Dialog", 1, 12));
        this.irLabel.setText("IR");
        this.irLabel.setForeground(registerTextColor);
        this.irLabel.setToolTipText("Instruction Register");
        this.regIR.setPreferredSize(new Dimension(52, 20));
        this.regIR.setBorder(BorderFactory.createLoweredBevelBorder());
        this.regIR.setFont(new Font("Monospaced", 0, 14));
        this.regIR.setValue(0);
        this.regIR.setEditable(false);
        this.irModeBox.setPreferredSize(new Dimension(57, 20));
        this.irModeBox.setBackground(registerForeground);
        this.irModeBox.setFont(new Font("Dialog", 0, 11));
        this.irModeBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = MarieSim.this.irModeBox.getSelectedIndex();
                MarieSim.this.regIR.setMode(n);
            }
        });
        this.irPanel.add(this.irLabel);
        this.irPanel.add(this.regIR);
        this.irPanel.add(this.irModeBox);
        this.registersPanel.add(this.irPanel);
        this.marPanel.setPreferredSize(new Dimension(172, 34));
        this.marPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.marPanel.setBackground(registerForeground);
        this.marPanel.setLayout(new FlowLayout());
        this.marLabel.setPreferredSize(new Dimension(30, 15));
        this.marLabel.setFont(new Font("Dialog", 1, 12));
        this.marLabel.setText("MAR");
        this.marLabel.setForeground(registerTextColor);
        this.marLabel.setToolTipText("Memory Address Register");
        this.regMAR.setPreferredSize(new Dimension(52, 20));
        this.regMAR.setBorder(BorderFactory.createLoweredBevelBorder());
        this.regMAR.setFont(new Font("Monospaced", 0, 14));
        this.regMAR.setValue(0);
        this.regMAR.setEditable(false);
        this.marModeBox.setPreferredSize(new Dimension(57, 20));
        this.marModeBox.setBackground(registerForeground);
        this.marModeBox.setFont(new Font("Dialog", 0, 11));
        this.marModeBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = MarieSim.this.marModeBox.getSelectedIndex();
                MarieSim.this.regMAR.setMode(n);
            }
        });
        this.marPanel.add(this.marLabel);
        this.marPanel.add(this.regMAR);
        this.marPanel.add(this.marModeBox);
        this.registersPanel.add(this.marPanel);
        this.mbrPanel.setPreferredSize(new Dimension(172, 34));
        this.mbrPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.mbrPanel.setBackground(registerForeground);
        this.mbrPanel.setLayout(new FlowLayout());
        this.mbrLabel.setPreferredSize(new Dimension(30, 15));
        this.mbrLabel.setFont(new Font("Dialog", 1, 12));
        this.mbrLabel.setText("MBR");
        this.mbrLabel.setForeground(registerTextColor);
        this.mbrLabel.setToolTipText("Memory Buffer Register");
        this.regMBR.setPreferredSize(new Dimension(52, 20));
        this.regMBR.setBorder(BorderFactory.createLoweredBevelBorder());
        this.regMBR.setFont(new Font("Monospaced", 0, 14));
        this.regMBR.setValue(0);
        this.regMBR.setEditable(false);
        this.mbrModeBox.setPreferredSize(new Dimension(57, 20));
        this.mbrModeBox.setBackground(registerForeground);
        this.mbrModeBox.setFont(new Font("Dialog", 0, 11));
        this.mbrModeBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = MarieSim.this.mbrModeBox.getSelectedIndex();
                MarieSim.this.regMBR.setMode(n);
            }
        });
        this.mbrPanel.add(this.mbrLabel);
        this.mbrPanel.add(this.regMBR);
        this.mbrPanel.add(this.mbrModeBox);
        this.registersPanel.add(this.mbrPanel);
        this.pcPanel.setPreferredSize(new Dimension(172, 35));
        this.pcPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.pcPanel.setBackground(registerForeground);
        this.pcPanel.setLayout(new FlowLayout());
        this.pcLabel.setPreferredSize(new Dimension(30, 15));
        this.pcLabel.setFont(new Font("Dialog", 1, 12));
        this.pcLabel.setText("PC");
        this.pcLabel.setForeground(registerTextColor);
        this.pcLabel.setToolTipText("Program counter");
        this.regPC.setPreferredSize(new Dimension(52, 20));
        this.regPC.setBorder(BorderFactory.createLoweredBevelBorder());
        this.regPC.setFont(new Font("Monospaced", 0, 14));
        this.regPC.setValue(0);
        this.regPC.setEditable(false);
        this.pcModeBox.setPreferredSize(new Dimension(57, 20));
        this.pcModeBox.setBackground(registerForeground);
        this.pcModeBox.setFont(new Font("Dialog", 0, 11));
        this.pcModeBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = MarieSim.this.pcModeBox.getSelectedIndex();
                MarieSim.this.regPC.setMode(n);
            }
        });
        this.pcPanel.add(this.pcLabel);
        this.pcPanel.add(this.regPC);
        this.pcPanel.add(this.pcModeBox);
        this.registersPanel.add(this.pcPanel);
        this.inputPanel.setPreferredSize(new Dimension(172, 35));
        this.inputPanel.setLayout(new FlowLayout());
        this.inputPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.inputPanel.setBackground(registerForeground);
        this.inputLabel.setPreferredSize(new Dimension(33, 15));
        this.inputLabel.setFont(new Font("Dialog", 1, 11));
        this.inputLabel.setText("INPUT");
        this.inputLabel.setForeground(registerTextColor);
        this.inputLabel.setToolTipText("Input Register");
        this.regINPUT.setPreferredSize(new Dimension(52, 20));
        this.regINPUT.setBorder(BorderFactory.createLoweredBevelBorder());
        this.regINPUT.setFont(new Font("Monospaced", 0, 14));
        this.regINPUT.setValue(0);
        this.regINPUT.setMode(2);
        this.regINPUT.setEditable(false);
        this.regINPUT.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieSim.this.input();
            }
        });
        this.inputModeBox.setPreferredSize(new Dimension(57, 20));
        this.inputModeBox.setBackground(registerForeground);
        this.inputModeBox.setFont(new Font("Dialog", 0, 11));
        this.inputModeBox.setSelectedIndex(2);
        this.inputModeBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = MarieSim.this.inputModeBox.getSelectedIndex();
                MarieSim.this.regINPUT.setMode(n);
            }
        });
        this.inputPanel.add(this.inputLabel);
        this.inputPanel.add(this.regINPUT);
        this.inputPanel.add(this.inputModeBox);
        this.registersPanel.add(this.inputPanel);
        this.mainPanel.add(this.registersPanel);
        this.outputScrollPane.getViewport().setBackground(Color.white);
        this.outputScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.outputScrollPane.setVerticalScrollBarPolicy(22);
        this.outputScrollPane.setPreferredSize(new Dimension(158, 166));
        this.outputArea.setFont(new Font("Monospaced", 0, 12));
        this.outputArea.setBorder(BorderFactory.createLineBorder(Color.white, 4));
        this.outputScrollPane.getViewport().add((Component)this.outputArea, null);
        this.outputModeBox.setPreferredSize(new Dimension(60, 22));
        this.outputModeBox.setBackground(registerForeground);
        this.outputModeBox.setFont(new Font("Dialog", 0, 11));
        this.outputModeBox.setToolTipText("Output can be displayed in hex, decimal or ASCII.");
        this.outputModeBox.setSelectedIndex(2);
        this.regOUTPUT.setMode(2);
        this.outputModeBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = MarieSim.this.outputModeBox.getSelectedIndex();
                if (MarieSim.this.regOUTPUT.mode != n) {
                    MarieSim.this.regOUTPUT.setMode(n);
                    MarieSim.this.reformatOutput();
                }
            }
        });
        this.outputControlBox.setFont(new Font("Dialog", 0, 11));
        this.outputControlBox.setBackground(registerForeground);
        this.outputControlBox.setPreferredSize(new Dimension(98, 22));
        this.outputControlBox.setToolTipText("Linefeed control and printing.");
        this.outputControlBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = MarieSim.this.outputControlBox.getSelectedIndex();
                switch (n) {
                    case 1: {
                        MarieSim.this.outputWithLinefeed = true;
                        break;
                    }
                    case 2: {
                        MarieSim.this.outputWithLinefeed = false;
                        break;
                    }
                    case 3: {
                        MarieSim.this.outputArea.setText("");
                        outputStream = new Vector();
                        MarieSim.this.outputControlBox.setSelectedIndex(0);
                        break;
                    }
                    case 4: {
                        MarieSim.this.printOutput();
                    }
                }
            }
        });
        this.outputOuterPanel.setPreferredSize(new Dimension(208, 250));
        this.outputOuterPanel.setBackground(registerBackground);
        this.outputOuterPanel.setBorder(BorderFactory.createEtchedBorder());
        this.outputInnerPanel.setBackground(registerForeground);
        this.outputInnerBorder.setTitleColor(registerTextColor);
        this.outputInnerPanel.setBorder(this.outputInnerBorder);
        this.outputInnerPanel.setPreferredSize(new Dimension(186, 232));
        this.outputInnerPanel.setLayout(new FlowLayout());
        this.outputInnerPanel.add(this.outputScrollPane);
        this.outputInnerPanel.add(this.outputModeBox);
        this.outputInnerPanel.add(this.outputControlBox);
        this.outputOuterPanel.add(this.outputInnerPanel);
        this.mainPanel.add(this.outputOuterPanel);
        this.simulatorPane.add(this.mainPanel);
        this.bottomPanel.setPreferredSize(new Dimension(760, 210));
        this.bottomPanel.setLayout(new FlowLayout());
        this.bottomPanel.setBackground(simulatorBackground);
        this.memoryPane = this.createMemoryPanel();
        this.memoryPane.setPreferredSize(new Dimension(692, 155));
        this.memoryPane.setBorder(BorderFactory.createEtchedBorder());
        this.msgField.setBackground(messageBackground);
        this.msgField.setFont(new Font("SansSerif", 0, 11));
        this.msgField.setPreferredSize(new Dimension(740, 40));
        this.msgField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(simulatorBackground, 10), BorderFactory.createLoweredBevelBorder()));
        this.msgField.setEditable(false);
        this.setStatusMessage(" Ready to load program instructions.");
        this.bottomPanel.add(this.memoryPane);
        this.bottomPanel.add(this.msgField);
        this.simulatorPane.add(this.bottomPanel);
        this.validate();
    }

    JScrollPane createProgramPanel() {
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel(){
            int colno = 0;

            public void addColumn(TableColumn tableColumn) {
                switch (this.colno) {
                    case 0: 
                    case 1: {
                        ++this.colno;
                        return;
                    }
                    case 3: {
                        tableColumn.setMinWidth(62);
                        tableColumn.setMaxWidth(62);
                        tableColumn.setPreferredWidth(62);
                        break;
                    }
                    case 5: {
                        tableColumn.setMinWidth(40);
                        tableColumn.setMaxWidth(40);
                        tableColumn.setPreferredWidth(40);
                        break;
                    }
                    default: {
                        tableColumn.setMinWidth(68);
                        tableColumn.setMaxWidth(68);
                    }
                }
                super.addColumn(tableColumn);
                ++this.colno;
                if (this.colno > 5) {
                    this.colno = 0;
                }
            }
        };
        DefaultTableColumnModel defaultTableColumnModel2 = new DefaultTableColumnModel(){
            int twocols = 0;

            public void addColumn(TableColumn tableColumn) {
                if (this.twocols < 2) {
                    if (this.twocols == 0) {
                        tableColumn.setMaxWidth(20);
                    } else {
                        tableColumn.setMaxWidth(40);
                    }
                    ++this.twocols;
                    super.addColumn(tableColumn);
                }
            }
        };
        this.programTable = new JTable(this.ptm, defaultTableColumnModel);
        this.programTable.setRowSelectionAllowed(false);
        this.programTable.setCellSelectionEnabled(false);
        this.programTable.setSelectionBackground(Color.white);
        this.programTable.setShowHorizontalLines(false);
        this.programTable.setShowVerticalLines(false);
        this.programTable.setIntercellSpacing(new Dimension(0, 1));
        this.programTable.setRowHeight(19);
        class ProgramTableCellRenderer
        extends JLabel
        implements TableCellRenderer {
            private final /* synthetic */ MarieSim this$0;

            ProgramTableCellRenderer(MarieSim marieSim) {
                this.this$0 = marieSim;
            }

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.setText((String)object);
                this.setFont(new Font("Monospaced", 0, 12));
                this.setOpaque(true);
                this.setBackground(Color.white);
                this.setForeground(Color.black);
                this.setBorder(new EmptyBorder(0, 0, 0, 0));
                if (n == this.this$0.programFocusRow) {
                    this.setBackground(Color.green);
                } else {
                    this.setBackground(Color.white);
                }
                return this;
            }
        }
        ProgramTableCellRenderer programTableCellRenderer = new ProgramTableCellRenderer(this);
        this.programTable.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = MarieSim.class$("java.lang.Object")) : class$java$lang$Object, programTableCellRenderer);
        JTableHeader jTableHeader = this.programTable.getTableHeader();
        jTableHeader.setForeground(tableHeaderColor);
        jTableHeader.setFont(new Font("Dialog", 0, 11));
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setResizingAllowed(false);
        jTableHeader.setBorder(new EtchedBorder(1));
        this.programTable.createDefaultColumnsFromModel();
        JTable jTable = new JTable(this.ptm, defaultTableColumnModel2);
        jTable.createDefaultColumnsFromModel();
        jTable.setMaximumSize(new Dimension(60, 10000));
        jTable.setBackground(new Color(224, 224, 224));
        jTable.setShowVerticalLines(false);
        jTable.setSelectionBackground(Color.lightGray);
        jTable.setBorder(new EtchedBorder(1));
        jTable.setColumnSelectionAllowed(false);
        jTable.setCellSelectionEnabled(false);
        jTable.setOpaque(false);
        class RowHeaderTableCellRenderer
        extends JLabel
        implements TableCellRenderer {
            private final /* synthetic */ MarieSim this$0;

            RowHeaderTableCellRenderer(MarieSim marieSim) {
                this.this$0 = marieSim;
            }

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (n2 > 0) {
                    this.setText((String)object);
                    this.setBackground(Color.lightGray);
                }
                this.setToolTipText("Check box to set breakpoint.");
                this.setFont(new Font("sanserif", 0, 11));
                this.setForeground(new Color(0, 50, 165));
                return this;
            }
        }
        RowHeaderTableCellRenderer rowHeaderTableCellRenderer = new RowHeaderTableCellRenderer(this);
        jTable.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = MarieSim.class$("java.lang.Object")) : class$java$lang$Object, rowHeaderTableCellRenderer);
        jTable.setRowHeight(19);
        this.programTable.setSelectionModel(jTable.getSelectionModel());
        JViewport jViewport = new JViewport();
        jViewport.setView(jTable);
        jViewport.setPreferredSize(jTable.getMaximumSize());
        jTable.setAutoResizeMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.programTable, 22, 31);
        this.codeLineCount = 12;
        this.programArray = new Object[12][6];
        int n = 0;
        while (n < 12) {
            this.programArray[n][0] = new Boolean(false);
            this.programArray[n][1] = "  ";
            this.programArray[n][2] = "  ";
            this.programArray[n][3] = "  ";
            this.programArray[n][4] = "  ";
            this.programArray[n][5] = "  ";
            ++n;
        }
        jScrollPane.setRowHeader(jViewport);
        return jScrollPane;
    }

    JScrollPane createMemoryPanel() {
        AbstractTableModel abstractTableModel = new AbstractTableModel(){
            String[] headers = new String[]{" ", "+0", "+1", "+2", "+3", "+4", "+5", "+6", "+7", "+8", "+9", "+A", "+B", "+C", "+D", "+E", "+F"};

            public int getColumnCount() {
                return this.headers.length;
            }

            public int getRowCount() {
                return 256;
            }

            public String getColumnName(int n) {
                return this.headers[n];
            }

            public Object getValueAt(int n, int n2) {
                return MarieSim.this.memoryArray[n][n2];
            }

            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            public void setValueAt(Object object, int n, int n2) {
                MarieSim.this.memoryArray[n][n2] = object;
                this.fireTableDataChanged();
            }

            public Class getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }
        };
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel(){
            boolean first = true;

            public void addColumn(TableColumn tableColumn) {
                if (this.first) {
                    this.first = false;
                    return;
                }
                tableColumn.setMinWidth(40);
                tableColumn.setMaxWidth(40);
                tableColumn.setPreferredWidth(40);
                super.addColumn(tableColumn);
            }
        };
        DefaultTableColumnModel defaultTableColumnModel2 = new DefaultTableColumnModel(){
            boolean first = true;

            public void addColumn(TableColumn tableColumn) {
                if (this.first) {
                    tableColumn.setMaxWidth(30);
                    super.addColumn(tableColumn);
                    this.first = false;
                }
            }
        };
        this.memoryTable = new JTable(abstractTableModel, defaultTableColumnModel);
        this.memoryTable.setRowSelectionAllowed(false);
        this.memoryTable.setCellSelectionEnabled(false);
        this.memoryTable.setSelectionBackground(Color.white);
        this.memoryTable.setShowHorizontalLines(false);
        this.memoryTable.setShowVerticalLines(false);
        this.memoryTable.setRowHeight(15);
        class MemoryTableCellRenderer
        extends JLabel
        implements TableCellRenderer {
            private final /* synthetic */ MarieSim this$0;

            MemoryTableCellRenderer(MarieSim marieSim) {
                this.this$0 = marieSim;
            }

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.setText((String)object);
                this.setFont(new Font("Monospaced", 0, 11));
                this.setOpaque(true);
                this.setBackground(Color.white);
                this.setForeground(Color.black);
                this.setBorder(new EmptyBorder(0, 0, 0, 0));
                if (n * 16 + n2 == this.this$0.memoryFocusCell) {
                    this.setBackground(Color.green);
                } else {
                    this.setBackground(Color.white);
                }
                return this;
            }
        }
        MemoryTableCellRenderer memoryTableCellRenderer = new MemoryTableCellRenderer(this);
        this.memoryTable.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = MarieSim.class$("java.lang.Object")) : class$java$lang$Object, memoryTableCellRenderer);
        JTableHeader jTableHeader = this.memoryTable.getTableHeader();
        jTableHeader.setForeground(tableHeaderColor);
        jTableHeader.setFont(new Font("Dialog", 0, 11));
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setResizingAllowed(false);
        jTableHeader.setBorder(new EtchedBorder(1));
        this.memoryTable.createDefaultColumnsFromModel();
        JTable jTable = new JTable(abstractTableModel, defaultTableColumnModel2);
        jTable.createDefaultColumnsFromModel();
        jTable.setMaximumSize(new Dimension(30, 150));
        jTable.setBackground(Color.lightGray);
        jTable.setOpaque(false);
        jTable.setShowVerticalLines(false);
        jTable.setSelectionBackground(Color.lightGray);
        jTable.setBorder(new EtchedBorder(1));
        jTable.setColumnSelectionAllowed(false);
        jTable.setCellSelectionEnabled(false);
        class RowHeaderTableCellRenderer
        extends JLabel
        implements TableCellRenderer {
            private final /* synthetic */ MarieSim this$0;

            RowHeaderTableCellRenderer(MarieSim marieSim) {
                this.this$0 = marieSim;
            }

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.setText((String)object);
                this.setFont(new Font("Dialog", 0, 11));
                this.setForeground(tableHeaderColor);
                return this;
            }
        }
        RowHeaderTableCellRenderer rowHeaderTableCellRenderer = new RowHeaderTableCellRenderer(this);
        jTable.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = MarieSim.class$("java.lang.Object")) : class$java$lang$Object, rowHeaderTableCellRenderer);
        jTable.setRowHeight(15);
        this.memoryTable.setSelectionModel(jTable.getSelectionModel());
        JViewport jViewport = new JViewport();
        jViewport.setView(jTable);
        jViewport.setPreferredSize(jTable.getMaximumSize());
        jTable.setAutoResizeMode(0);
        JViewport jViewport2 = new JViewport();
        jViewport2.setView(this.memoryTable);
        jViewport2.setPreferredSize(this.memoryTable.getMaximumSize());
        this.memoryTable.setAutoResizeMode(0);
        int n = 0;
        while (n < 4095) {
            Arrays.fill(this.memoryArray[n / 16], " 0000");
            this.memoryArray[n / 16][0] = "  " + this.to3CharHexStr(n);
            n += 16;
        }
        JScrollPane jScrollPane = new JScrollPane(this.memoryTable);
        jScrollPane.setRowHeader(jViewport);
        return jScrollPane;
    }

    void confirmReset() {
        JFrame jFrame = new JFrame("Confirm Reset");
        jFrame.setIconImage(Toolkit.getDefaultToolkit().createImage((class$MarieSimulator$MarieSim == null ? (class$MarieSimulator$MarieSim = MarieSim.class$("MarieSimulator.MarieSim")) : class$MarieSimulator$MarieSim).getResource("M.gif")));
        int n = JOptionPane.showOptionDialog(jFrame, "Are you sure?", "Reset Confirmation", 0, 3, null, new Object[]{"Yes", "No"}, "No");
        if (n == 1) {
            return;
        }
        this.marieReset();
    }

    void displayEditorFrame() {
        try {
            this.marieEditor.show();
            this.marieEditor.requestFocus();
        }
        catch (Exception exception) {
            if (mexFile != null) {
                this.marieEditor = new MarieEditor(mexFile + SRC_TYPE, false);
                this.reloadFileItem.setEnabled(true);
            } else {
                this.marieEditor = new MarieEditor(false);
            }
            this.marieEditor.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    MarieSim.this.marieEditor = null;
                }
            });
        }
    }

    void displayDelayFrame() {
        try {
            this.delayFrame.show();
            this.delayFrame.requestFocus();
        }
        catch (Exception exception) {
            this.delayFrame = new DelayFrame();
            this.delayFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    MarieSim.this.delayFrame = null;
                }
            });
        }
    }

    void displayHelpAboutFrame() {
        try {
            this.helpAboutFrame.show();
            this.helpAboutFrame.requestFocus();
        }
        catch (Exception exception) {
            this.helpAboutFrame = new HelpAboutFrame(this);
            this.helpAboutFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    MarieSim.this.helpAboutFrame = null;
                }
            });
        }
    }

    void displayCoreDump() {
        try {
            this.dumpViewer.show();
            this.dumpViewer.requestFocus();
        }
        catch (Exception exception) {
            try {
                this.dumpFrame.requestFocus();
            }
            catch (Exception exception2) {
                this.dumpFrame = new CoreDumpFrame();
                this.dumpFrame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        MarieSim.this.dumpFrame = null;
                    }
                });
            }
        }
    }

    void displaySymbolTable() {
        try {
            this.symbolTable.show();
            this.symbolTable.requestFocus();
        }
        catch (Exception exception) {
            this.symbolTable = new TextFileViewer("Symbol Table", mexFile + MAP_TYPE, false);
            this.symbolTable.setSize(200, 280);
            this.symbolTable.setLocation(550, 40);
            this.symbolTable.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    MarieSim.this.symbolTable = null;
                }
            });
            this.symbolTable.show();
        }
    }

    void displayHelpFrame() {
        try {
            this.helpViewer.show();
            this.helpViewer.requestFocus();
        }
        catch (Exception exception) {
            this.helpViewer = new TextFileViewer("Simulator Help", HELP_FILE, false);
            this.helpViewer.setSize(400, 280);
            this.helpViewer.setLocation(350, 50);
            this.helpViewer.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    MarieSim.this.helpViewer = null;
                }
            });
            this.helpViewer.show();
        }
    }

    void printOutput() {
        Object object;
        BufferedWriter bufferedWriter = null;
        String string = formfeed;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter("msim.tmp"));
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return;
        }
        try {
            bufferedWriter.write(this.outputArea.getText());
            bufferedWriter.write(string);
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return;
        }
        DocFlavor.INPUT_STREAM iNPUT_STREAM = DocFlavor.INPUT_STREAM.AUTOSENSE;
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(iNPUT_STREAM, hashPrintRequestAttributeSet);
        PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
        PrintService printService2 = ServiceUI.printDialog(null, 100, 100, printServiceArray, printService, iNPUT_STREAM, hashPrintRequestAttributeSet);
        if (printService2 != null) {
            try {
                object = printService2.createPrintJob();
                FileInputStream fileInputStream = new FileInputStream("msim.tmp");
                HashDocAttributeSet hashDocAttributeSet = new HashDocAttributeSet();
                SimpleDoc simpleDoc = new SimpleDoc(fileInputStream, iNPUT_STREAM, hashDocAttributeSet);
                object.print(simpleDoc, hashPrintRequestAttributeSet);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            object = new File("msim.tmp");
            ((File)object).delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.exitProgram();
        }
    }

    void exitProgram() {
        JFrame jFrame = new JFrame("Confirm Quit");
        jFrame.setIconImage(Toolkit.getDefaultToolkit().createImage((class$MarieSimulator$MarieSim == null ? (class$MarieSimulator$MarieSim = MarieSim.class$("MarieSimulator.MarieSim")) : class$MarieSimulator$MarieSim).getResource("M.gif")));
        int n = JOptionPane.showOptionDialog(jFrame, "Really quit?", "Quit Confirmation", 0, 3, null, new Object[]{"Yes", "No"}, "Yes");
        if (n == 0) {
            System.exit(0);
        }
    }

    int stringToInt(int n, String string) {
        this.errorFound = false;
        String string2 = string.trim();
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        switch (n) {
            case 1: {
                try {
                    n2 = (short)Integer.parseInt(string2, 10);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    this.errorFound = true;
                    return n3;
                }
            }
            case 0: {
                try {
                    n2 = (short)Integer.parseInt(string2, 16);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    this.errorFound = true;
                    return n3;
                }
            }
            case 2: {
                if (string2.length() == 0) {
                    return 0;
                }
                char c = string2.charAt(0);
                return c % 128;
            }
        }
        n3 = n2;
        return n3;
    }

    String to3CharHexStr(int n) {
        if (n < 0) {
            n <<= 20;
        }
        String string = Integer.toHexString(n).toUpperCase();
        switch (string.length()) {
            case 1: {
                string = "00" + string;
                break;
            }
            case 2: {
                string = "0" + string;
                break;
            }
            case 3: {
                break;
            }
            default: {
                string = string.substring(0, 3);
            }
        }
        return string;
    }

    String to4CharHexStr(int n) {
        if (n < 0) {
            n <<= 16;
        }
        String string = Integer.toHexString(n).toUpperCase();
        switch (string.length()) {
            case 1: {
                string = "000" + string;
                break;
            }
            case 2: {
                string = "00" + string;
                break;
            }
            case 3: {
                string = "0" + string;
                break;
            }
            case 4: {
                break;
            }
            default: {
                return string.substring(0, 4);
            }
        }
        return string;
    }

    String rightJustifyIn4(String string) {
        StringBuffer stringBuffer = new StringBuffer("    ");
        int n = string.length();
        int n2 = 3;
        int n3 = n - 1;
        while (n3 >= 0 && n2 >= 0) {
            stringBuffer.setCharAt(n2--, string.charAt(n3));
            --n3;
        }
        return stringBuffer.toString();
    }

    void dumpRegs(BufferedWriter bufferedWriter) throws Exception {
        bufferedWriter.write(linefeed);
        bufferedWriter.write("    PC: " + this.regPC + "   MAR: " + this.regMAR + "      AC: " + this.regAC + linefeed);
        bufferedWriter.write("    IR: " + this.regIR + "   MBR: " + this.regMBR + "   INPUT:  ");
        if (this.regINPUT.toString() != null) {
            bufferedWriter.write(this.regINPUT.toString().trim());
        } else {
            bufferedWriter.write("null");
        }
        bufferedWriter.write("  OUTPUT: ");
        if (this.regOUTPUT.toString() != null) {
            bufferedWriter.write(this.regOUTPUT.toString().trim() + linefeed);
        } else {
            bufferedWriter.write("null" + linefeed);
        }
    }

    void dumpMemory(int n, int n2, BufferedWriter bufferedWriter) throws Exception {
        if (n < 0 || n2 < 0) {
            n = 0;
            n2 = 4095;
        }
        int n3 = n;
        int n4 = 0;
        bufferedWriter.write(linefeed);
        bufferedWriter.write("       ");
        bufferedWriter.write("Memory dump for addresses " + this.to3CharHexStr(n));
        bufferedWriter.write(" through " + this.to3CharHexStr(n2) + linefeed + linefeed);
        while (n3 <= 4095) {
            if (n4 == 0) {
                bufferedWriter.write(" " + this.to3CharHexStr(n3) + ":  ");
            }
            bufferedWriter.write(this.memoryArray[n3 / 16][n3 % 16 + 1].toString() + "  ");
            if (n3 == n2) {
                bufferedWriter.write(linefeed);
                return;
            }
            if (++n4 == 8) {
                n4 = 0;
                bufferedWriter.write(linefeed);
            }
            ++n3;
        }
        bufferedWriter.write(linefeed);
    }

    void produceCoreDump(int n, int n2) {
        BufferedWriter bufferedWriter = null;
        boolean bl = false;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(mexFile + DMP_TYPE));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.setStatusMessage(" Error!  Cannot create core dump file.");
            return;
        }
        catch (IOException iOException) {
            this.setStatusMessage(" " + iOException);
            return;
        }
        try {
            bufferedWriter.write("Machine dump for " + mexFile + MEX_TYPE + "           " + new Date() + linefeed + linefeed);
            this.dumpRegs(bufferedWriter);
        }
        catch (Exception exception) {
            this.setStatusMessage(" " + exception);
        }
        try {
            this.dumpMemory(n, n2, bufferedWriter);
        }
        catch (Exception exception) {
            this.setStatusMessage(" " + exception);
        }
        try {
            bufferedWriter.write(formfeed);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            this.setStatusMessage(" " + iOException);
        }
        this.dumpViewer = new TextFileViewer("Core Dump", mexFile + DMP_TYPE, false);
        this.dumpViewer.setSize(600, 400);
        this.dumpViewer.setLocation(150, 40);
        this.dumpViewer.show();
    }

    void setStatusMessage(String string) {
        statusMessage = string;
        this.msgField.setText(statusMessage);
        this.msgField.postActionEvent();
    }

    void reformatOutput() {
        Enumeration enumeration = outputStream.elements();
        this.outputArea.setText("");
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            switch (this.regOUTPUT.mode) {
                case 0: {
                    this.outputArea.append(this.to4CharHexStr(n));
                    break;
                }
                case 1: {
                    this.outputArea.append(n.toString());
                    break;
                }
                default: {
                    this.outputArea.append("" + (char)(n % 128));
                }
            }
            if (this.outputWithLinefeed) {
                this.outputArea.append(linefeed);
                continue;
            }
            if (n != 13 || this.regOUTPUT.mode != 2) continue;
            this.outputArea.append(linefeed);
        }
        this.outputArea.repaint();
    }

    void getProgram() {
        String string = null;
        if (0 != exeFileChooser.showOpenDialog(this)) {
            this.setStatusMessage(" File loading canceled.");
            return;
        }
        string = exeFileChooser.getSelectedFile().getPath();
        int n = 0;
        int n2 = 0;
        n = string.lastIndexOf(fileSeparator);
        if (n < 0) {
            n = -1;
        } else {
            mexPath = string.substring(0, n);
        }
        n2 = string.lastIndexOf(MEX_TYPE);
        if (n2 > 0) {
            mexFile = mexPath + fileSeparator + string.substring(n + 1, n2);
        }
        try {
            this.symbolTable.dispose();
            this.symbolTable = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.dumpViewer.dispose();
            this.dumpViewer = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadProgram();
    }

    void loadProgram() {
        File file = null;
        ObjectInputStream objectInputStream = null;
        AssembledCodeLine assembledCodeLine = new AssembledCodeLine();
        Vector<AssembledCodeLine> vector = new Vector<AssembledCodeLine>();
        this.errorFound = false;
        if (mexFile == null) {
            this.setStatusMessage(" No file to load.  Use File+Load menu picks.");
            return;
        }
        this.reloadFileItem.setEnabled(false);
        this.runRunItem.setEnabled(false);
        this.getDump.setEnabled(false);
        this.breakpointMenu.setEnabled(false);
        this.showSymbols.setEnabled(false);
        try {
            file = new File(mexFile + MEX_TYPE);
            objectInputStream = new ObjectInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.setStatusMessage(" File " + mexFile + MEX_TYPE + " not found.");
            this.errorFound = true;
        }
        catch (IOException iOException) {
            this.setStatusMessage(" " + iOException);
            this.errorFound = true;
        }
        catch (Exception exception) {
            this.setStatusMessage(" " + exception);
            this.errorFound = true;
        }
        if (this.errorFound) {
            return;
        }
        this.marieReset();
        if (this.codeLineCount >= 0) {
            int n = 0;
            while (n < this.codeLineCount) {
                this.programArray[n][0] = new Boolean(false);
                this.programArray[n][1] = "  ";
                this.programArray[n][2] = "  ";
                this.programArray[n][3] = "  ";
                this.programArray[n][4] = "  ";
                this.programArray[n][5] = "  ";
                ++n;
            }
        }
        this.codeLineCount = 0;
        boolean bl = false;
        while (!bl) {
            if (this.codeLineCount >= 4095) {
                this.setStatusMessage(" Maximum program statements reached.");
                this.errorFound = true;
                bl = true;
            }
            try {
                assembledCodeLine = (AssembledCodeLine)objectInputStream.readObject();
                if (assembledCodeLine == null) {
                    bl = true;
                } else if (assembledCodeLine.lineNo.charAt(0) != ' ') {
                    vector.add(assembledCodeLine);
                    ++this.codeLineCount;
                }
            }
            catch (EOFException eOFException) {
                bl = true;
            }
            catch (IOException iOException) {
                this.setStatusMessage(" " + iOException);
                this.errorFound = true;
                bl = true;
            }
            catch (Exception exception) {
                this.setStatusMessage(" " + exception);
                this.errorFound = true;
                bl = true;
            }
            if (bl) break;
        }
        try {
            objectInputStream.close();
            file = null;
        }
        catch (IOException iOException) {
            this.setStatusMessage(" " + iOException);
        }
        if (this.errorFound) {
            return;
        }
        int n = 0;
        this.programArray = new Object[this.codeLineCount][6];
        this.codeReference.clear();
        Enumeration enumeration = vector.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            assembledCodeLine = (AssembledCodeLine)enumeration.nextElement();
            this.programArray[n2][0] = new Boolean(false);
            this.programArray[n2][1] = "  " + assembledCodeLine.lineNo;
            this.programArray[n2][2] = " " + assembledCodeLine.stmtLabel;
            this.programArray[n2][3] = assembledCodeLine.mnemonic;
            this.programArray[n2][4] = assembledCodeLine.operandToken;
            this.programArray[n2][5] = " " + assembledCodeLine.hexCode + assembledCodeLine.operand;
            this.codeReference.put(assembledCodeLine.lineNo, new Integer(n2));
            ++n2;
            try {
                n = Integer.parseInt(assembledCodeLine.lineNo, 16);
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            this.memoryArray[n / 16][n % 16 + 1] = " " + assembledCodeLine.hexCode + assembledCodeLine.operand;
        }
        this.ptm.fireTableStructureChanged();
        String string = (String)this.programArray[0][1];
        try {
            n = Integer.parseInt(string.trim(), 16);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int n3 = n / 16;
        int n4 = n % 16 + 1;
        Rectangle rectangle = this.memoryTable.getCellRect(n3, n4, false);
        this.memoryTable.scrollRectToVisible(rectangle);
        this.regPC.setValue(n);
        this.regPC.postActionEvent();
        rectangle = this.programTable.getCellRect(0, 2, false);
        this.programFocusRow = 0;
        this.programTable.scrollRectToVisible(rectangle);
        this.programPane.repaint();
        this.memoryPane.repaint();
        this.setStatusMessage(" " + mexPath + fileSeparator + mexFile + MEX_TYPE + " loaded.");
        this.reloadFileItem.setEnabled(true);
        this.runRunItem.setEnabled(true);
        this.getDump.setEnabled(true);
        this.breakpointMenu.setEnabled(true);
        this.breakpointOn = false;
        this.step.setEnabled(true);
        this.stepRunOff.setEnabled(true);
        this.stepRunOn.setEnabled(false);
        this.checkForMap();
        if (this.stepping) {
            this.step.setEnabled(true);
        }
        this.machineState = 0;
    }

    void checkForMap() {
        this.showSymbols.setEnabled(true);
        try {
            FileInputStream fileInputStream = new FileInputStream(mexFile + MAP_TYPE);
        }
        catch (IOException iOException) {
            this.showSymbols.setEnabled(false);
        }
    }

    void restart() {
        if (this.machineState == 57005 || this.machineState == -3) {
            return;
        }
        this.fatalError = false;
        this.errorCode = 0;
        this.regINPUT.setEditable(false);
        this.regINPUT.repaint();
        if (this.stepping) {
            this.setStatusMessage(" Press [Step] to start.");
            this.step.setEnabled(true);
        } else {
            this.setStatusMessage("  Press [Run] to start.");
        }
        this.regPC.setValue(((String)this.programArray[0][1]).trim());
        Rectangle rectangle = this.programTable.getCellRect(0, 2, false);
        this.programFocusRow = 0;
        this.programTable.scrollRectToVisible(rectangle);
        this.machineState = 1;
        this.programTable.repaint();
    }

    void marieReset() {
        this.regAC.setValue(0);
        this.regAC.postActionEvent();
        this.regIR.setValue(0);
        this.regIR.postActionEvent();
        this.regMAR.setValue(0);
        this.regMAR.postActionEvent();
        this.regMBR.setValue(0);
        this.regMBR.postActionEvent();
        this.regPC.setValue(0);
        this.regPC.postActionEvent();
        this.regINPUT.setValue(0);
        this.regINPUT.setEditable(false);
        this.regOUTPUT.setValue(0);
        this.outputArea.setText("");
        this.outputArea.setText("");
        outputStream = new Vector();
        int n = 0;
        while (n < 4095) {
            Arrays.fill(this.memoryArray[n / 16], " 0000");
            this.memoryArray[n / 16][0] = "  " + this.to3CharHexStr(n);
            n += 16;
        }
        if (this.codeLineCount >= 0) {
            int n2 = 0;
            while (n2 < this.codeLineCount) {
                this.programArray[n2][0] = new Boolean(false);
                this.programArray[n2][1] = "  ";
                this.programArray[n2][2] = "  ";
                this.programArray[n2][3] = "  ";
                this.programArray[n2][4] = "  ";
                this.programArray[n2][5] = "  ";
                ++n2;
            }
        }
        this.programFocusRow = 0;
        this.memoryFocusCell = 0;
        this.machineState = -3;
        this.runRunItem.setEnabled(false);
        this.restartItem.setEnabled(false);
        this.reloadFileItem.setEnabled(false);
        this.showSymbols.setEnabled(false);
        this.setStatusMessage(" ");
        this.breakpointOn = false;
        this.repaint();
    }

    void fetchNext() {
        Rectangle rectangle;
        if (this.fatalError) {
            this.halt();
            return;
        }
        this.regMAR.setValue(this.regPC.getValue());
        this.regMAR.postActionEvent();
        int n = this.regMAR.getValue();
        int n2 = n / 16;
        int n3 = n % 16 + 1;
        try {
            this.regIR.setValue((" " + (String)this.memoryArray[n2][n3]).trim());
            this.regIR.postActionEvent();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.errorCode = 3;
            this.fatalError = true;
            return;
        }
        String string = this.regPC.toString().trim();
        if (this.codeReference.containsKey(string)) {
            this.programFocusRow = (Integer)this.codeReference.get(string);
            rectangle = this.programTable.getCellRect(this.programFocusRow, 5, false);
            this.programTable.scrollRectToVisible(rectangle);
        }
        string = this.regIR.toString().trim();
        try {
            this.instructionCode = Integer.parseInt(string.substring(0, 1), 16);
            if (this.instructionCode >= operandReqd.length) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.fatalError = true;
            this.errorCode = 1;
            return;
        }
        if (operandReqd[this.instructionCode]) {
            this.regMAR.setValue(this.regIR.toString().trim().substring(1, 4));
            this.regMAR.postActionEvent();
            n = this.regMAR.getValue();
            n2 = n / 16;
            n3 = n % 16 + 1;
            this.memoryFocusCell = n;
            try {
                rectangle = this.memoryTable.getCellRect(n2, n3, false);
                this.memoryTable.scrollRectToVisible(rectangle);
                this.regMBR.setValue((" " + this.memoryArray[n2][n3]).trim());
                if (this.fatalError) {
                    return;
                }
                this.regMBR.postActionEvent();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.errorCode = 3;
                this.fatalError = true;
                return;
            }
        }
        this.regPC.setValue(this.regPC.getValue() + 1);
        if (this.regPC.getValue() > 4095) {
            this.errorCode = 8;
            this.fatalError = true;
        }
        if (this.fatalError) {
            return;
        }
        this.regPC.postActionEvent();
        this.errorFound = false;
        this.machineState = 1;
        this.programTable.repaint();
        this.memoryTable.repaint();
    }

    void execute() {
        switch (this.instructionCode) {
            case 0: {
                this.jnS();
                break;
            }
            case 1: {
                this.load();
                break;
            }
            case 2: {
                this.store();
                break;
            }
            case 3: {
                this.add();
                break;
            }
            case 4: {
                this.subt();
                break;
            }
            case 5: {
                this.input();
                break;
            }
            case 6: {
                this.output();
                break;
            }
            case 7: {
                this.halt();
                break;
            }
            case 8: {
                this.skipCond();
                break;
            }
            case 9: {
                this.jump();
                break;
            }
            case 10: {
                this.clear();
                break;
            }
            case 11: {
                this.addI();
                break;
            }
            case 12: {
                this.jumpI();
                break;
            }
            default: {
                this.fatalError = true;
                this.errorCode = 1;
            }
        }
    }

    void jnS() {
        int n = this.regMAR.getValue();
        int n2 = n / 16;
        int n3 = n % 16 + 1;
        try {
            this.memoryArray[n2][n3] = " " + this.to4CharHexStr(this.regPC.getValue());
            this.regPC.setValue(this.regMAR.getValue() + 1);
            this.regPC.postActionEvent();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.errorCode = 3;
            this.fatalError = true;
        }
    }

    void load() {
        this.regAC.setValue(this.regMBR.getValue());
        this.regAC.postActionEvent();
    }

    void store() {
        this.regMBR.setValue(this.regAC.getValue());
        if (this.fatalError) {
            return;
        }
        int n = this.regMAR.getValue();
        int n2 = n / 16;
        int n3 = n % 16 + 1;
        try {
            this.memoryArray[n2][n3] = " " + this.to4CharHexStr(this.regMBR.getValue());
            Rectangle rectangle = this.memoryTable.getCellRect(n2, n3, false);
            this.memoryTable.scrollRectToVisible(rectangle);
            this.regMBR.postActionEvent();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.errorCode = 3;
            this.fatalError = true;
        }
    }

    void add() {
        this.regAC.setValue(this.regAC.getValue() + this.regMBR.getValue());
        this.regAC.postActionEvent();
    }

    void subt() {
        this.regAC.setValue(this.regAC.getValue() - this.regMBR.getValue());
        this.regAC.postActionEvent();
    }

    void input() {
        if (this.machineState == 1) {
            this.setStatusMessage(" Waiting for input.");
            this.machineState = 2;
            this.regINPUT.setText("");
            this.inputPanel.setBackground(Color.pink);
            this.inputModeBox.setBackground(Color.pink);
            this.regINPUT.setEditable(true);
            this.regINPUT.repaint();
            this.regINPUT.requestFocus();
        } else if (this.machineState == 2) {
            this.regINPUT.setValue(this.regINPUT.getText());
            this.regINPUT.setEditable(false);
            this.runStop.requestFocus();
            this.inputPanel.setBackground(registerForeground);
            this.inputModeBox.setBackground(registerForeground);
            this.regINPUT.repaint();
            if (this.fatalError) {
                this.halt();
                return;
            }
            this.regAC.setValue(this.regINPUT.getValue());
            if (this.fatalError) {
                this.halt();
                return;
            }
            this.regAC.repaint();
            this.machineState = 1;
            if (this.stepping) {
                this.setStatusMessage(" Press [Step] to continue.");
            } else {
                this.setStatusMessage(" ");
                if (this.breakpointOn) {
                    this.runToBreakpoint();
                } else {
                    this.runProgram();
                }
            }
        }
    }

    void output() {
        this.regOUTPUT.setValue(this.regAC.getValue());
        outputStream.addElement(new Integer(this.regOUTPUT.getValue()));
        if (this.regOUTPUT.toString() != null) {
            this.outputArea.append(this.regOUTPUT.toString().trim());
        }
        if (this.outputWithLinefeed) {
            this.outputArea.append(linefeed);
        } else if (this.regOUTPUT.getValue() == 13 && this.regOUTPUT.mode == 2) {
            this.outputArea.append(linefeed);
        }
        Document document = this.outputArea.getDocument();
        this.outputArea.select(document.getLength(), document.getLength());
    }

    void halt() {
        this.step.setEnabled(false);
        this.runStop.setEnabled(false);
        if (this.fatalError) {
            this.machineState = -1;
            if (this.errorCode < errorMsgs.length) {
                this.setStatusMessage(" Machine halted abnormally.  Error: " + errorMsgs[this.errorCode]);
            } else {
                this.setStatusMessage(" Machine halted abnormally.");
            }
        } else {
            this.machineState = 0;
            this.setStatusMessage(" Machine halted normally.");
        }
    }

    void skipCond() {
        int n = this.regIR.getValue();
        n &= 0xC00;
        if ((n >>= 10) == 3) {
            this.fatalError = true;
            this.errorCode = 2;
            return;
        }
        int n2 = this.regAC.getValue();
        if (n2 < 0 && n == 0 || n2 == 0 && n == 1 || n2 > 0 && n == 2) {
            this.regPC.setValue(this.regPC.getValue() + 1);
            if (this.fatalError) {
                return;
            }
            this.regPC.postActionEvent();
        }
    }

    void jump() {
        int n = this.regIR.getValue();
        this.regPC.setValue(n &= 0xFFF);
        if (this.fatalError) {
            return;
        }
        this.regPC.postActionEvent();
    }

    void clear() {
        this.regAC.setValue(0);
        this.regAC.postActionEvent();
    }

    void addI() {
        this.regMAR.setValue(this.regMBR.getValue());
        if (this.fatalError) {
            return;
        }
        int n = this.regMAR.getValue();
        int n2 = n / 16;
        int n3 = n % 16 + 1;
        try {
            this.regMBR.setValue(" " + this.memoryArray[n2][n3]);
            this.regMAR.postActionEvent();
            this.regMBR.postActionEvent();
            this.add();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.errorCode = 3;
            this.fatalError = true;
            return;
        }
    }

    void jumpI() {
        this.regPC.setValue(this.regMBR.getValue());
        if (this.fatalError) {
            return;
        }
        this.regPC.postActionEvent();
    }

    void runToBreakpoint() {
        Runnable runnable = new Runnable(){
            int lastStatementRun;
            Boolean isBreakpoint;
            String aString;

            public void run() {
                MarieSim.this.machineState = 1;
                while (MarieSim.this.machineState == 1 && !MarieSim.this.fatalError) {
                    MarieSim.this.runStop.setEnabled(true);
                    this.aString = MarieSim.this.regPC.toString().trim();
                    if (MarieSim.this.codeReference.containsKey(this.aString)) {
                        this.lastStatementRun = (Integer)MarieSim.this.codeReference.get(this.aString);
                    }
                    MarieSim.this.fetchNext();
                    try {
                        Thread.sleep(MarieSim.this.delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!MarieSim.this.fatalError) {
                        MarieSim.this.execute();
                    }
                    this.isBreakpoint = (Boolean)MarieSim.this.programArray[this.lastStatementRun][0];
                    if (MarieSim.this.machineState == 1 && this.isBreakpoint.booleanValue()) {
                        MarieSim.this.machineState = 3;
                        MarieSim.this.setStatusMessage(" Stopped for breakpoint.");
                    }
                    MarieSim.this.repaint();
                }
            }
        };
        if (this.machineState == 57005 || this.machineState == -3) {
            return;
        }
        if (this.machineState == 0 || this.machineState == -1) {
            this.restart();
        }
        this.fatalError = false;
        this.validate();
        this.breakpointOn = true;
        Thread thread = new Thread(runnable);
        thread.start();
        if (this.fatalError) {
            this.halt();
        }
    }

    void clearBreakPoints() {
        int n = 0;
        while (n < this.codeLineCount) {
            this.programArray[n][0] = new Boolean(false);
            ++n;
        }
        this.programTable.repaint();
        this.breakpointOn = false;
    }

    void runProgram() {
        Runnable runnable = new Runnable(){

            public void run() {
                while (MarieSim.this.machineState == 1 && !MarieSim.this.fatalError) {
                    MarieSim.this.fetchNext();
                    try {
                        Thread.sleep(MarieSim.this.delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (MarieSim.this.fatalError) continue;
                    MarieSim.this.execute();
                }
                if (MarieSim.this.fatalError) {
                    MarieSim.this.halt();
                }
            }
        };
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setStatusMessage(" ");
        this.breakpointOn = false;
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public static void main(String[] stringArray) {
        MarieSim marieSim = new MarieSim();
        marieSim.show();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Register
    extends JTextField {
        int designation;
        short value;
        int mode;
        String rendering;

        public Register(int n) {
            if (n >= 0 && n <= 6) {
                this.designation = n;
            } else {
                MarieSim.this.fatalError = true;
                MarieSim.this.errorCode = 6;
            }
            this.setValue(0);
            this.mode = 0;
        }

        public void setMode(int n) {
            this.mode = n == 1 || n == 2 ? n : 0;
            this.setValue(this.value);
        }

        public void setValue(int n) {
            this.value = (short)n;
            if (!(this.designation != 2 && this.designation != 4 || this.value >= 0 && this.value <= 4095)) {
                this.value = (short)(n & 0xFFF);
            }
            switch (this.mode) {
                case 0: {
                    if (this.designation == 2 || this.designation == 4) {
                        this.rendering = "  " + MarieSim.this.to3CharHexStr(this.value);
                        break;
                    }
                    this.rendering = " " + MarieSim.this.to4CharHexStr(this.value);
                    break;
                }
                case 2: {
                    if (n == 0) {
                        this.rendering = null;
                        break;
                    }
                    this.rendering = "    " + (char)(n % 128);
                    break;
                }
                default: {
                    this.rendering = this.designation != 6 && this.value > 0 ? " " + Integer.toString(this.value) : Integer.toString(this.value);
                }
            }
            this.setText(this.rendering);
        }

        public void setValue(String string) {
            this.value = (short)MarieSim.this.stringToInt(this.mode, string);
            if (!MarieSim.this.errorFound) {
                this.setValue(this.value);
            } else {
                MarieSim.this.fatalError = true;
                MarieSim.this.errorCode = 7;
            }
        }

        public String toString() {
            return this.rendering;
        }

        public int getValue() {
            if ((this.designation == 2 || this.designation == 4) && this.value < 0) {
                short s = this.value;
                this.value = (short)(s & 0xFFF);
            }
            return this.value;
        }
    }

    class ProgramTableModel
    extends AbstractTableModel {
        String[] headers = new String[]{" ", " ", "label", "opcode", "operand", "hex"};

        ProgramTableModel() {
        }

        public int getColumnCount() {
            return this.headers.length;
        }

        public int getRowCount() {
            return MarieSim.this.codeLineCount;
        }

        public String getColumnName(int n) {
            return this.headers[n];
        }

        public Object getValueAt(int n, int n2) {
            return MarieSim.this.programArray[n][n2];
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void setValueAt(Object object, int n, int n2) {
            MarieSim.this.programArray[n][n2] = object;
            this.fireTableDataChanged();
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }

    class MarieExecutableFileFilter
    extends FileFilter {
        String myFileType = ".mex";

        MarieExecutableFileFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().endsWith(this.myFileType);
        }

        public String getDescription() {
            return "*" + this.myFileType;
        }
    }

    public class HelpAboutFrame
    extends JDialog
    implements ActionListener {
        JPanel mainPanel = new JPanel();
        JPanel centerPanel = new JPanel();
        JPanel logoPanel = new JPanel();
        JLabel logoLabel = new JLabel();
        ImageIcon logo = new ImageIcon();
        JPanel infoPanel = new JPanel();
        JLabel pgmTitle = new JLabel("MARIE Machine Simulator - Version 1.3.01");
        JLabel copyRight = new JLabel("Copyright (c) 2003, 2006");
        JLabel accompany = new JLabel("To accompany:");
        JLabel theBook = new JLabel("The Essentials of Computer Organization and Architecture 2/e  ");
        JLabel authors = new JLabel("By Linda M. Null & Julia M. Lobur");
        JLabel publisher = new JLabel("Jones & Bartlett Publishers");
        JPanel okBttonPanel = new JPanel();
        JButton okButton = new JButton("Ok");
        GridLayout gridLayout = new GridLayout();

        public HelpAboutFrame(Frame frame) {
            super(frame);
            this.setTitle("About this Program");
            this.enableEvents(64L);
            this.mainPanel.setLayout(new BorderLayout());
            this.logo = new ImageIcon((class$MarieSimulator$MarieDPath == null ? (class$MarieSimulator$MarieDPath = MarieSim.class$("MarieSimulator.MarieDPath")) : class$MarieSimulator$MarieDPath).getResource("ECOA.jpg"));
            this.logoPanel.setLayout(new FlowLayout());
            this.logoPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.logoLabel.setIcon(this.logo);
            this.logoPanel.add((Component)this.logoLabel, null);
            this.centerPanel.setLayout(new BorderLayout());
            this.centerPanel.add((Component)this.logoPanel, "West");
            this.copyRight.setFont(new Font("sanserif", 0, 12));
            this.accompany.setFont(new Font("sanserif", 0, 12));
            this.theBook.setFont(new Font("sanserif", 3, 14));
            this.authors.setFont(new Font("sanserif", 0, 12));
            this.publisher.setFont(new Font("sanserif", 0, 12));
            this.infoPanel.setLayout(this.gridLayout);
            this.gridLayout.setRows(6);
            this.gridLayout.setColumns(1);
            this.infoPanel.setBorder(BorderFactory.createEmptyBorder(10, 60, 10, 10));
            this.okBttonPanel.setLayout(new FlowLayout());
            this.okButton.addActionListener(this);
            this.getContentPane().add((Component)this.mainPanel, null);
            this.infoPanel.add((Component)this.pgmTitle, null);
            this.infoPanel.add((Component)this.copyRight, null);
            this.infoPanel.add((Component)this.accompany, null);
            this.infoPanel.add((Component)this.theBook, null);
            this.infoPanel.add((Component)this.authors, null);
            this.infoPanel.add((Component)this.publisher, null);
            this.centerPanel.add((Component)this.infoPanel, "Center");
            this.mainPanel.add((Component)this.centerPanel, "North");
            this.okBttonPanel.add((Component)this.okButton, null);
            this.mainPanel.add((Component)this.okBttonPanel, "South");
            this.setResizable(true);
            this.setLocation(75, 75);
            this.setModal(true);
            this.pack();
            this.show();
        }

        protected void processWindowEvent(WindowEvent windowEvent) {
            if (windowEvent.getID() == 201) {
                this.cancel();
            }
            super.processWindowEvent(windowEvent);
        }

        void cancel() {
            this.dispose();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.okButton) {
                this.cancel();
            }
        }
    }

    class CoreDumpFrame
    extends JFrame {
        JPanel buttons = new JPanel();
        JLabel sliderLabel = new JLabel("Select memory range to dump.");
        JSlider starting;
        JSlider ending;
        JTextField startAddr = new JTextField();
        JTextField endAddr = new JTextField();
        JLabel blankLabel = new JLabel();
        JButton okayButton = new JButton("Okay");
        JButton cancelButton = new JButton("Cancel");
        int sliderStart;
        int sliderEnd;

        CoreDumpFrame() {
            super("Core Dump");
            JPanel jPanel = (JPanel)this.getContentPane();
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ CoreDumpFrame this$1;
                {
                    this.this$1 = coreDumpFrame;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    this.this$1.dispose();
                }
            });
            this.setIconImage(Toolkit.getDefaultToolkit().createImage((class$MarieSimulator$MarieSim == null ? (class$MarieSimulator$MarieSim = MarieSim.class$("MarieSimulator.MarieSim")) : class$MarieSimulator$MarieSim).getResource("M.gif")));
            this.setSize(new Dimension(500, 300));
            jPanel.setPreferredSize(new Dimension(450, 150));
            jPanel.setLayout(new FlowLayout());
            this.sliderStart = MarieSim.this.stringToInt(0, ((String)MarieSim.this.programArray[0][1]).trim());
            this.sliderEnd = this.sliderStart + MarieSim.this.codeLineCount - 1;
            this.sliderLabel.setPreferredSize(new Dimension(250, 30));
            this.sliderLabel.setForeground(Color.black);
            this.starting = new JSlider(0, 0, 4095, this.sliderStart);
            this.starting.setMajorTickSpacing(1024);
            this.starting.setMinorTickSpacing(128);
            this.starting.setPaintTicks(true);
            this.starting.setPaintLabels(true);
            this.starting.setValue(this.sliderStart);
            this.starting.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(145, 145, 210), 2), " Starting Memory Address "));
            this.starting.setPreferredSize(new Dimension(400, 80));
            this.starting.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ CoreDumpFrame this$1;
                {
                    this.this$1 = coreDumpFrame;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    if (!jSlider.getValueIsAdjusting()) {
                        this.this$1.sliderStart = jSlider.getValue();
                        this.this$1.startAddr.setText(" " + Integer.toHexString(this.this$1.sliderStart).toUpperCase());
                        this.this$1.startAddr.postActionEvent();
                        if (this.this$1.sliderStart > this.this$1.sliderEnd) {
                            this.this$1.sliderEnd = this.this$1.sliderStart;
                            this.this$1.endAddr.setText(" " + Integer.toHexString(this.this$1.sliderEnd).toUpperCase());
                            this.this$1.endAddr.postActionEvent();
                            this.this$1.ending.setValue(this.this$1.sliderStart);
                        }
                    }
                }
            });
            this.startAddr.setPreferredSize(new Dimension(57, 30));
            this.startAddr.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(145, 145, 210), 2), BorderFactory.createLoweredBevelBorder()));
            this.startAddr.setFont(new Font("Monospaced", 0, 14));
            this.startAddr.setText(" " + MarieSim.this.to3CharHexStr(this.sliderStart));
            this.startAddr.setEditable(false);
            this.startAddr.setForeground(Color.black);
            this.ending = new JSlider(0, 0, 4095, this.sliderStart);
            this.ending.setValue(this.sliderEnd);
            this.ending.setMajorTickSpacing(1024);
            this.ending.setMinorTickSpacing(128);
            this.ending.setPaintTicks(true);
            this.ending.setPaintLabels(true);
            this.ending.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(145, 145, 210), 2), " Ending Memory Address "));
            this.ending.setPreferredSize(new Dimension(400, 80));
            this.ending.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ CoreDumpFrame this$1;
                {
                    this.this$1 = coreDumpFrame;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    if (!jSlider.getValueIsAdjusting()) {
                        this.this$1.sliderEnd = jSlider.getValue();
                        this.this$1.endAddr.setText(" " + Integer.toHexString(this.this$1.sliderEnd).toUpperCase());
                        this.this$1.endAddr.postActionEvent();
                        if (this.this$1.sliderEnd < this.this$1.sliderStart) {
                            this.this$1.sliderStart = this.this$1.sliderEnd;
                            this.this$1.startAddr.setText(" " + Integer.toHexString(this.this$1.sliderStart).toUpperCase());
                            this.this$1.startAddr.postActionEvent();
                            this.this$1.starting.setValue(this.this$1.sliderEnd);
                        }
                    }
                }
            });
            this.endAddr.setPreferredSize(new Dimension(57, 30));
            this.endAddr.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(145, 145, 210), 2), BorderFactory.createLoweredBevelBorder()));
            this.endAddr.setFont(new Font("Monospaced", 0, 14));
            this.endAddr.setText(" " + MarieSim.this.to3CharHexStr(this.sliderEnd));
            this.endAddr.setEditable(false);
            this.blankLabel.setPreferredSize(new Dimension(30, 35));
            this.okayButton.setMaximumSize(new Dimension(80, 35));
            this.okayButton.setMinimumSize(new Dimension(80, 35));
            this.okayButton.setPreferredSize(new Dimension(80, 35));
            this.okayButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ CoreDumpFrame this$1;
                {
                    this.this$1 = coreDumpFrame;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    CoreDumpFrame.access$100(this.this$1).produceCoreDump(this.this$1.sliderStart, this.this$1.sliderEnd);
                    WindowEvent windowEvent = new WindowEvent(this.this$1, 201);
                    this.this$1.dispatchEvent(windowEvent);
                }
            });
            this.cancelButton.setMaximumSize(new Dimension(80, 35));
            this.cancelButton.setMinimumSize(new Dimension(80, 35));
            this.cancelButton.setPreferredSize(new Dimension(80, 35));
            this.cancelButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ CoreDumpFrame this$1;
                {
                    this.this$1 = coreDumpFrame;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    WindowEvent windowEvent = new WindowEvent(this.this$1, 201);
                    this.this$1.dispatchEvent(windowEvent);
                }
            });
            this.buttons.setPreferredSize(new Dimension(300, 75));
            this.buttons.add(this.okayButton);
            this.buttons.add(this.cancelButton);
            jPanel.add(this.sliderLabel);
            jPanel.add(this.starting);
            jPanel.add(this.startAddr);
            jPanel.add(this.ending);
            jPanel.add(this.endAddr);
            jPanel.add(this.buttons);
            this.setLocation(200, 75);
            this.show();
        }

        static /* synthetic */ MarieSim access$100(CoreDumpFrame coreDumpFrame) {
            return coreDumpFrame.MarieSim.this;
        }
    }

    class DelayFrame
    extends JFrame {
        JPanel buttons = new JPanel();
        JLabel sliderLabel = new JLabel("Select instruction execution delay in milliseconds.");
        JTextField msDelay = new JTextField();
        JLabel blankLabel = new JLabel();
        JButton okayButton = new JButton("Okay");
        JButton cancelButton = new JButton("Cancel");
        int sliderDelay;

        DelayFrame() {
            super("Set Delay");
            this.sliderDelay = MarieSim.this.delay;
            JPanel jPanel = (JPanel)this.getContentPane();
            this.setSize(new Dimension(400, 200));
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ DelayFrame this$1;
                {
                    this.this$1 = delayFrame;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    this.this$1.dispose();
                }
            });
            jPanel.setPreferredSize(new Dimension(350, 150));
            jPanel.setLayout(new FlowLayout());
            this.setIconImage(Toolkit.getDefaultToolkit().createImage((class$MarieSimulator$MarieSim == null ? (class$MarieSimulator$MarieSim = MarieSim.class$("MarieSimulator.MarieSim")) : class$MarieSimulator$MarieSim).getResource("M.gif")));
            MarieSim.this.setStatusMessage(" Execution delay set at " + MarieSim.this.delay + " milliseconds.");
            this.sliderLabel.setPreferredSize(new Dimension(300, 50));
            this.sliderLabel.setForeground(Color.black);
            JSlider jSlider = new JSlider(0, 0, 3000, MarieSim.this.delay);
            jSlider.setMajorTickSpacing(1000);
            jSlider.setMinorTickSpacing(100);
            jSlider.setPaintTicks(true);
            jSlider.setPaintLabels(true);
            jSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            jSlider.setPreferredSize(new Dimension(325, 50));
            jSlider.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ DelayFrame this$1;
                {
                    this.this$1 = delayFrame;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    if (!jSlider.getValueIsAdjusting()) {
                        this.this$1.sliderDelay = jSlider.getValue();
                        this.this$1.msDelay.setText(" " + this.this$1.sliderDelay);
                        this.this$1.msDelay.postActionEvent();
                    }
                }
            });
            this.msDelay.setPreferredSize(new Dimension(57, 30));
            this.msDelay.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(145, 145, 210), 2), BorderFactory.createLoweredBevelBorder()));
            this.msDelay.setFont(new Font("Monospaced", 0, 14));
            this.msDelay.setText(" " + MarieSim.this.delay);
            this.msDelay.setEditable(false);
            this.blankLabel.setPreferredSize(new Dimension(30, 35));
            this.okayButton.setMaximumSize(new Dimension(80, 35));
            this.okayButton.setMinimumSize(new Dimension(80, 35));
            this.okayButton.setPreferredSize(new Dimension(80, 35));
            JRootPane jRootPane = this.getRootPane();
            jRootPane.setDefaultButton(this.okayButton);
            this.okayButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ DelayFrame this$1;
                {
                    this.this$1 = delayFrame;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.this$1.sliderDelay < 10) {
                        this.this$1.sliderDelay = 10;
                    }
                    DelayFrame.access$000((DelayFrame)this.this$1).delay = this.this$1.sliderDelay;
                    DelayFrame.access$000(this.this$1).setStatusMessage(" Execution delay set at " + DelayFrame.access$000((DelayFrame)this.this$1).delay + " milliseconds.");
                    WindowEvent windowEvent = new WindowEvent(this.this$1, 201);
                    this.this$1.dispatchEvent(windowEvent);
                }
            });
            this.cancelButton.setMaximumSize(new Dimension(80, 35));
            this.cancelButton.setMinimumSize(new Dimension(80, 35));
            this.cancelButton.setPreferredSize(new Dimension(80, 35));
            this.cancelButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ DelayFrame this$1;
                {
                    this.this$1 = delayFrame;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    WindowEvent windowEvent = new WindowEvent(this.this$1, 201);
                    this.this$1.dispatchEvent(windowEvent);
                }
            });
            this.buttons.setPreferredSize(new Dimension(300, 75));
            this.buttons.add(this.msDelay);
            this.buttons.add(this.blankLabel);
            this.buttons.add(this.okayButton);
            this.buttons.add(this.cancelButton);
            jPanel.add(this.sliderLabel);
            jPanel.add(jSlider);
            jPanel.add(this.buttons);
            this.setLocation(200, 75);
            this.show();
        }

        static /* synthetic */ MarieSim access$000(DelayFrame delayFrame) {
            return delayFrame.MarieSim.this;
        }
    }
}

