/*
 * Decompiled with CFR 0.152.
 */
package MarieSimulator;

import MarieSimulator.AssembledCodeLine;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Assembler
implements Serializable {
    public BufferedReader sourceFile = null;
    public File objectFile = null;
    public ObjectOutputStream objFileOut = null;
    public BufferedWriter lstFile = null;
    public ObjectInputStream objFileIn = null;
    public BufferedWriter mapFile = null;
    public String sourceFileName = null;
    public static final String sourceType = "mas";
    public static final String listType = "lst";
    public static final String mapType = "map";
    public static final String exeType = "mex";
    public static final int MAX_MARIE_INT = Short.MAX_VALUE;
    public static final int MIN_MARIE_INT = Short.MIN_VALUE;
    public static final int MAX_MARIE_ADDR = 4095;
    public static final int DEC = -1;
    public static final int OCT = -2;
    public static final int HEX = -3;
    public static final int ORG = -4;
    public static final int END = -5;
    public static final int MAX_SYMBOL_PRINT_LEN = 24;
    public static final int LABEL_DELIM = 44;
    public static final int COMMENT_DELIM = 47;
    public static final String fileSeparator = System.getProperty("file.separator");
    public static final String lineFeed = System.getProperty("line.separator");
    public static final String formFeed = "\f";
    public static final String[] errorMsgs = new String[]{"ORiGination directive must be first noncomment line of program ", "A label cannot have 0..9 as its beginning character.", "Statement label must be unique.", "Instruction not recognized.", "Missing instruction.", "Missing operand.", "Hex address literal out of range 0 to 0FFF allowable.", "Invalid decimal value: -32768 to 32767 allowable.", "Invalid octal value: 00000 to 177777 allowable.", "Invalid hexadecimal value: 0 to FFFF allowable.", "Operand undefined.", "Maximum source lines exceeded.  Assembly halted.", "Maximum line number exceeded.  Assembly halted."};
    public Hashtable symbolTable = new Hashtable(18, 0.75f);
    public final Hashtable instructionSet = new Hashtable(18);
    public int lineNumber;
    public int errorCount = 0;
    public boolean errorFound = false;
    public boolean done;
    public ArrayList errorList = new ArrayList();
    public boolean operandReqd = false;
    public boolean hasLabel = false;
    public int maxSymbolLength = 0;

    void loadInstructionSet() {
        this.instructionSet.put("JNS", new Instruction("JNS", 0, true));
        this.instructionSet.put("LOAD", new Instruction("LOAD", 1, true));
        this.instructionSet.put("STORE", new Instruction("STORE", 2, true));
        this.instructionSet.put("ADD", new Instruction("ADD", 3, true));
        this.instructionSet.put("SUBT", new Instruction("SUBT", 4, true));
        this.instructionSet.put("INPUT", new Instruction("INPUT", 5, false));
        this.instructionSet.put("OUTPUT", new Instruction("OUTPUT", 6, false));
        this.instructionSet.put("HALT", new Instruction("HALT", 7, false));
        this.instructionSet.put("SKIPCOND", new Instruction("SKIPCOND", 8, true));
        this.instructionSet.put("JUMP", new Instruction("JUMP", 9, true));
        this.instructionSet.put("CLEAR", new Instruction("CLEAR", 10, false));
        this.instructionSet.put("ADDI", new Instruction("ADDI", 11, true));
        this.instructionSet.put("JUMPI", new Instruction("JUMPI", 12, true));
        this.instructionSet.put("DEC", new Instruction("DEC", -1, true));
        this.instructionSet.put("OCT", new Instruction("OCT", -2, true));
        this.instructionSet.put("HEX", new Instruction("HEX", -3, true));
        this.instructionSet.put("ORG", new Instruction("ORG", -4, true));
        this.instructionSet.put("END", new Instruction("END", -5, false));
    }

    String statementLabel(String string) {
        String string2 = null;
        int n = string.indexOf(44);
        if (n < 0) {
            return " ";
        }
        this.hasLabel = true;
        if (n == 0) {
            return " ";
        }
        string2 = string.substring(0, n);
        char c = string2.charAt(0);
        if (Character.isDigit(c)) {
            this.setErrorMessage(errorMsgs[1]);
            return " ";
        }
        if (!this.addedToSymbolTable(string2)) {
            return " ";
        }
        return string2;
    }

    boolean tokenIsLiteral(String string) {
        char[] cArray = string.toCharArray();
        if (!Character.isDigit(cArray[0])) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            if (!Character.isDigit(cArray[n])) {
                switch (cArray[n]) {
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            ++n;
        }
        return true;
    }

    int validMarieValue(int n) {
        if (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE) {
            return n;
        }
        int n2 = Math.abs(n);
        if (n2 >= Short.MAX_VALUE && n2 <= 65535) {
            return n2 - 65536;
        }
        return Integer.MAX_VALUE;
    }

    int literalToInt(int n, String string, boolean bl) {
        int n2 = Integer.MAX_VALUE;
        switch (n) {
            case -1: {
                try {
                    n2 = this.validMarieValue(Integer.parseInt(string, 10));
                    if (n2 == Integer.MAX_VALUE) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.setErrorMessage(errorMsgs[7]);
                    n2 = Integer.MAX_VALUE;
                }
                break;
            }
            case -2: {
                try {
                    n2 = this.validMarieValue(Integer.parseInt(string, 8));
                    if (n2 == Integer.MAX_VALUE) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.setErrorMessage(errorMsgs[8]);
                    n2 = Integer.MAX_VALUE;
                }
                break;
            }
            case -4: 
            case -3: {
                try {
                    n2 = this.validMarieValue(Integer.parseInt(string, 16));
                    if (n2 == Integer.MAX_VALUE) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (n == -4) {
                        this.setErrorMessage(errorMsgs[6]);
                    } else {
                        this.setErrorMessage(errorMsgs[9]);
                    }
                    n2 = Integer.MAX_VALUE;
                }
                break;
            }
        }
        if (n2 == Integer.MAX_VALUE) {
            return 0;
        }
        if (!(bl || n2 >= 0 && n2 <= 4095)) {
            this.setErrorMessage(errorMsgs[6]);
            n2 = 0;
        }
        return n2;
    }

    String to3CharHexStr(int n) {
        if (n < 0) {
            n <<= 20;
        }
        String string = Integer.toHexString(n).toUpperCase();
        switch (string.length()) {
            case 1: {
                string = "00" + string;
                break;
            }
            case 2: {
                string = "0" + string;
                break;
            }
            case 3: {
                break;
            }
            default: {
                string = string.substring(0, 3);
            }
        }
        return string;
    }

    String to4CharHexStr(int n) {
        if (n < 0) {
            n <<= 16;
        }
        String string = Integer.toHexString(n).toUpperCase();
        switch (string.length()) {
            case 1: {
                string = "000" + string;
                break;
            }
            case 2: {
                string = "00" + string;
                break;
            }
            case 3: {
                string = "0" + string;
                break;
            }
            case 4: {
                break;
            }
            default: {
                return string.substring(0, 4);
            }
        }
        return string;
    }

    boolean addedToSymbolTable(String string) {
        if (this.symbolTable.containsKey(string)) {
            this.setErrorMessage(errorMsgs[2]);
            return false;
        }
        SymbolEntry symbolEntry = new SymbolEntry(string, this.to3CharHexStr(this.lineNumber));
        this.symbolTable.put(string, symbolEntry);
        if (string.length() > this.maxSymbolLength) {
            this.maxSymbolLength = string.length();
        }
        return true;
    }

    String getSymbolAddress(String string, String string2) {
        String string3 = null;
        if (this.symbolTable.containsKey(string)) {
            SymbolEntry symbolEntry = (SymbolEntry)this.symbolTable.get(string);
            string3 = symbolEntry.address;
            symbolEntry.referencedAt.add(string2);
            this.symbolTable.put(string, symbolEntry);
        } else {
            this.setErrorMessage(errorMsgs[10]);
        }
        return string3;
    }

    String padStr(String string, int n) {
        int n2 = string.length();
        if (n2 > n) {
            n2 = n;
        }
        StringBuffer stringBuffer = new StringBuffer(string.substring(0, n2));
        int n3 = n2;
        while (n3 < n) {
            stringBuffer.append(" ");
            ++n3;
        }
        return stringBuffer.toString();
    }

    int getOpcode(String string) {
        int n = 0;
        if (this.instructionSet.containsKey(string)) {
            Instruction instruction = (Instruction)this.instructionSet.get(string);
            this.operandReqd = instruction.addrReqd;
            n = instruction.hexCode;
            if (instruction.hexCode == -4 && this.lineNumber > 0) {
                this.setErrorMessage(errorMsgs[0]);
                n = Integer.MIN_VALUE;
            }
        } else {
            this.setErrorMessage(errorMsgs[3]);
            n = Integer.MIN_VALUE;
        }
        return n;
    }

    void setErrorMessage(String string) {
        ++this.errorCount;
        this.errorFound = true;
        this.errorList.add(string);
    }

    /*
     * Unable to fully structure code
     */
    AssembledCodeLine parseCodeLine(String var1_1) {
        block23: {
            block21: {
                block22: {
                    var2_2 = new AssembledCodeLine();
                    var3_3 = new StringBuffer(" ");
                    var4_4 = new StringBuffer(" ");
                    var5_5 = new StringBuffer(" ");
                    var6_6 = 0;
                    var7_7 = 0;
                    this.errorList.clear();
                    this.errorFound = false;
                    var3_3.delete(0, var3_3.length());
                    var8_8 = var1_1.indexOf(47);
                    if (var8_8 < 0) {
                        var8_8 = var1_1.length();
                    }
                    if (var8_8 > 0) {
                        var3_3.append(var1_1.substring(0, var8_8));
                        var9_9 = var1_1.length();
                        if (var9_9 > 1 && var9_9 - var8_8 > 0) {
                            var2_2.comment = var1_1.substring(var8_8, var9_9);
                        }
                    }
                    var2_2.sourceLine = var1_1;
                    var4_4.delete(0, var4_4.length());
                    var9_10 = new StringTokenizer(var3_3.substring(0, var3_3.length()));
                    if (var9_10.countTokens() == 0) {
                        var2_2.comment = var1_1;
                        return var2_2;
                    }
                    ++this.lineNumber;
                    if (this.lineNumber > 4095) {
                        this.setErrorMessage(Assembler.errorMsgs[12]);
                        var10_11 = this.errorList.size();
                        var11_13 = 0;
                        while (var11_13 < var10_11) {
                            var2_2.errors.add((String)this.errorList.get(var11_13));
                            ++var11_13;
                        }
                        this.errorFound = true;
                        this.done = true;
                        return var2_2;
                    }
                    var10_12 = var9_10.nextToken();
                    this.hasLabel = false;
                    var4_4.append(this.statementLabel(var10_12.trim()));
                    var2_2.stmtLabel = var4_4.toString();
                    this.operandReqd = true;
                    if (this.hasLabel) {
                        if (var9_10.hasMoreTokens()) {
                            var10_12 = var9_10.nextToken().toUpperCase();
                            var6_6 = this.getOpcode(var10_12);
                            var2_2.mnemonic = var10_12;
                        } else {
                            this.setErrorMessage(Assembler.errorMsgs[4]);
                            this.operandReqd = false;
                            var6_6 = -2147483648;
                        }
                    } else {
                        var6_6 = this.getOpcode(var10_12.toUpperCase());
                        var2_2.mnemonic = var10_12.toUpperCase();
                    }
                    var5_5.delete(0, var5_5.length());
                    if (!this.operandReqd) break block21;
                    if (!var9_10.hasMoreTokens()) break block22;
                    var10_12 = var9_10.nextToken();
                    if (var6_6 < -4 || var6_6 >= 0) ** GOTO lbl76
                    var7_7 = this.literalToInt(var6_6, var10_12.toUpperCase(), true);
                    if (var6_6 > -4 || this.errorFound) {
                        var5_5.append(this.to4CharHexStr(var7_7));
                        var6_6 = this.literalToInt(-3, var5_5.substring(0, 1), false);
                        var5_5.deleteCharAt(0);
                        var2_2.operandToken = var10_12.toUpperCase();
                    } else {
                        this.lineNumber = var7_7 - 1;
                        var2_2.operandToken = var10_12.toUpperCase();
                        return var2_2;
lbl76:
                        // 1 sources

                        if (this.tokenIsLiteral(var10_12)) {
                            var7_7 = this.literalToInt(-3, var10_12, false);
                            var10_12 = this.to3CharHexStr(var7_7).toUpperCase();
                            var5_5.append(var10_12);
                            var2_2.operandToken = var10_12;
                        } else {
                            var5_5.append("_");
                            var5_5.append(var10_12);
                            var2_2.operandToken = var10_12;
                        }
                    }
                    break block23;
                }
                this.setErrorMessage(Assembler.errorMsgs[5]);
                var5_5.append("???");
                break block23;
            }
            var5_5.append("000");
        }
        var2_2.lineNo = this.to3CharHexStr(this.lineNumber);
        if (var6_6 >= 0) {
            var2_2.hexCode = Integer.toHexString(var6_6).toUpperCase();
        } else if (var6_6 < -15) {
            var2_2.hexCode = "?";
        } else if (var6_6 == -5) {
            var2_2.lineNo = "   ";
            var2_2.hexCode = " ";
            var5_5.delete(0, var5_5.length());
            var5_5.append("   ");
            this.done = true;
        }
        var2_2.operand = var5_5.toString();
        if (this.errorFound) {
            var11_14 = this.errorList.size();
            var12_15 = 0;
            while (var12_15 < var11_14) {
                var2_2.errors.add((String)this.errorList.get(var12_15));
                ++var12_15;
            }
        }
        return var2_2;
    }

    AssembledCodeLine symbolsToAddresses(AssembledCodeLine assembledCodeLine) {
        String string = assembledCodeLine.lineNo;
        this.errorFound = false;
        this.errorList.clear();
        if (assembledCodeLine.lineNo.charAt(0) == ' ') {
            return assembledCodeLine;
        }
        if (assembledCodeLine.operand.indexOf(95) == 0) {
            string = this.getSymbolAddress(assembledCodeLine.operand.substring(1, assembledCodeLine.operand.length()), string);
            assembledCodeLine.operand = string != null ? string : "???";
        }
        if (this.errorFound) {
            assembledCodeLine.errors.add((String)this.errorList.get(0));
        }
        return assembledCodeLine;
    }

    /*
     * Unable to fully structure code
     */
    int performFirstPass() {
        var1_1 = new AssembledCodeLine();
        this.done = false;
        this.errorFound = false;
        this.loadInstructionSet();
        this.openFirstPassFiles();
        if (!this.errorFound) ** GOTO lbl22
        return -1;
lbl-1000:
        // 1 sources

        {
            try {
                var2_2 = this.sourceFile.readLine();
                if (var2_2 != null) {
                    var1_1 = this.parseCodeLine(var2_2);
                    this.objFileOut.writeObject(var1_1);
                    continue;
                }
                this.done = true;
                continue;
            }
            catch (EOFException var2_3) {
                this.done = true;
                continue;
            }
            catch (IOException var3_4) {
                System.err.println(var3_4);
                return -1;
            }
lbl22:
            // 4 sources

            ** while (!this.done)
        }
lbl23:
        // 1 sources

        this.closeFirstPassFiles();
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    int performSecondPass() {
        this.errorFound = false;
        this.openSecondPassFiles();
        var1_1 = new AssembledCodeLine();
        this.done = false;
        if (!this.errorFound) ** GOTO lbl25
        return -1;
lbl-1000:
        // 1 sources

        {
            try {
                var1_1 = (AssembledCodeLine)this.objFileIn.readObject();
                if (var1_1 != null) {
                    var1_1 = this.symbolsToAddresses(var1_1);
                    this.objFileOut.writeObject(var1_1);
                    continue;
                }
                this.done = true;
                continue;
            }
            catch (EOFException var2_2) {
                this.done = true;
                continue;
            }
            catch (ClassNotFoundException var3_3) {
                this.done = true;
                System.err.println(var3_3);
                return -1;
            }
            catch (IOException var4_4) {
                System.err.println(var4_4);
                return -1;
            }
lbl25:
            // 4 sources

            ** while (!this.done)
        }
lbl26:
        // 1 sources

        this.closeSecondPassFiles();
        return 0;
    }

    void produceFinalOutput() {
        AssembledCodeLine assembledCodeLine = new AssembledCodeLine();
        this.done = false;
        this.openFinalFiles();
        int n = 0;
        n = this.sourceFileName.lastIndexOf(fileSeparator);
        String string = this.sourceFileName.substring(n + 1, this.sourceFileName.length());
        try {
            int n2 = 0;
            while (n2 < 5) {
                this.lstFile.write(" ");
                ++n2;
            }
            this.lstFile.write("Assembly listing for: " + string + "." + sourceType + lineFeed);
            int n3 = 0;
            while (n3 < 5) {
                this.lstFile.write(" ");
                ++n3;
            }
            this.lstFile.write("           Assembled: " + new Date() + lineFeed);
            this.lstFile.write(lineFeed);
        }
        catch (IOException iOException) {
            this.done = true;
            System.err.println(iOException);
        }
        if (this.maxSymbolLength < 6) {
            this.maxSymbolLength = 6;
        } else if (this.maxSymbolLength > 24) {
            this.maxSymbolLength = 24;
        }
        while (!this.done) {
            try {
                assembledCodeLine = (AssembledCodeLine)this.objFileIn.readObject();
                if (assembledCodeLine == null) {
                    this.done = true;
                } else {
                    this.lstFile.write(assembledCodeLine.lineNo + " ");
                    this.lstFile.write(assembledCodeLine.hexCode);
                    this.lstFile.write(assembledCodeLine.operand + " | ");
                    this.lstFile.write(" " + this.padStr(assembledCodeLine.stmtLabel, this.maxSymbolLength));
                    this.lstFile.write(" " + assembledCodeLine.mnemonic);
                    this.lstFile.write(" " + this.padStr(assembledCodeLine.operandToken, this.maxSymbolLength + (9 - assembledCodeLine.mnemonic.length())));
                    this.lstFile.write(" " + assembledCodeLine.comment + lineFeed);
                    int n4 = 0;
                    while (n4 < assembledCodeLine.errors.size()) {
                        this.lstFile.write("   **** " + assembledCodeLine.errors.get(n4) + lineFeed);
                        ++n4;
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.done = true;
                System.err.println(classNotFoundException);
            }
            catch (EOFException eOFException) {
                this.done = true;
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                this.done = true;
            }
            if (this.done) break;
        }
        try {
            this.lstFile.write(lineFeed);
            if (this.errorCount > 0) {
                this.lstFile.write(this.errorCount + " error");
                if (this.errorCount > 1) {
                    this.lstFile.write("s");
                }
                this.lstFile.write(" found.  Assembly unsuccessful." + lineFeed);
            } else {
                this.lstFile.write("Assembly successful." + lineFeed);
            }
            this.dumpSymbolTable();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            this.done = true;
        }
        this.closeFinalFiles();
    }

    void dumpSymbolTable() throws IOException {
        int n;
        int n2;
        SymbolEntry symbolEntry;
        int n3 = 0;
        String string = "         ";
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = this.symbolTable.elements();
        while (enumeration.hasMoreElements()) {
            symbolEntry = (SymbolEntry)enumeration.nextElement();
            arrayList.add(symbolEntry.symbol);
        }
        Collections.sort(arrayList);
        int n4 = 1;
        while (n4 < 2) {
            this.lstFile.write(lineFeed);
            ++n4;
        }
        this.lstFile.write(string);
        this.lstFile.write("SYMBOL TABLE" + lineFeed);
        this.lstFile.write(string + "-------");
        int n5 = 0;
        while (n5 < this.maxSymbolLength - 5) {
            this.lstFile.write("-");
            ++n5;
        }
        this.lstFile.write("------------------------------------------" + lineFeed);
        this.lstFile.write(string + " Symbol");
        int n6 = 0;
        while (n6 < this.maxSymbolLength - 5) {
            this.lstFile.write(" ");
            ++n6;
        }
        this.lstFile.write("| Defined | References " + lineFeed);
        this.lstFile.write(string + "-------");
        int n7 = 0;
        while (n7 < this.maxSymbolLength - 5) {
            this.lstFile.write("-");
            ++n7;
        }
        this.lstFile.write("+---------+-------------------------------");
        if (this.mapFile != null) {
            this.mapFile.write(" -----");
            n2 = 0;
            while (n2 < this.maxSymbolLength - 4) {
                this.mapFile.write("-");
                ++n2;
            }
            this.mapFile.write("----------" + lineFeed);
            this.mapFile.write(" Symbol");
            n = 0;
            while (n < this.maxSymbolLength - 5) {
                this.mapFile.write(" ");
                ++n;
            }
            this.mapFile.write("| Location" + lineFeed);
            this.mapFile.write(" ");
            this.mapFile.write("-----");
            int n8 = 0;
            while (n8 < this.maxSymbolLength - 4) {
                this.mapFile.write("-");
                ++n8;
            }
            this.mapFile.write("+---------");
        }
        n2 = 0;
        while (n2 < arrayList.size()) {
            symbolEntry = (SymbolEntry)this.symbolTable.get(arrayList.get(n2));
            this.lstFile.write(lineFeed);
            this.lstFile.write(string + " " + this.padStr(symbolEntry.symbol, this.maxSymbolLength) + " |   " + symbolEntry.address + "   | ");
            if (this.mapFile != null) {
                this.mapFile.write(lineFeed);
                this.mapFile.write(" " + this.padStr(symbolEntry.symbol, this.maxSymbolLength) + " |   " + symbolEntry.address);
            }
            Enumeration enumeration2 = symbolEntry.referencedAt.elements();
            n3 = 0;
            n = 1;
            while (enumeration2.hasMoreElements()) {
                if (n != 0) {
                    this.lstFile.write(enumeration2.nextElement().toString());
                    ++n3;
                    n = 0;
                    continue;
                }
                this.lstFile.write(", ");
                if (n3 % 6 == 0) {
                    this.lstFile.write(lineFeed);
                    this.lstFile.write(string + this.padStr(" ", this.maxSymbolLength) + "  |" + string + "| ");
                }
                this.lstFile.write(enumeration2.nextElement().toString());
                ++n3;
            }
            ++n2;
        }
        this.lstFile.write(lineFeed);
        this.lstFile.write(string + "-------");
        n = 0;
        while (n < this.maxSymbolLength - 5) {
            this.lstFile.write("-");
            ++n;
        }
        this.lstFile.write("------------------------------------------" + lineFeed);
        this.lstFile.write(lineFeed);
    }

    public static int assembleFile(String string) {
        Assembler assembler = new Assembler();
        int n = 0;
        if (string == null) {
            System.err.println("\nNull input file to assembler.");
            return -1;
        }
        int n2 = string.lastIndexOf(46);
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        assembler.sourceFileName = string;
        assembler.lineNumber = -1;
        n = assembler.performFirstPass();
        if (n == 0) {
            n = assembler.performSecondPass();
        } else {
            System.err.println("Irrecoverable IO error occurred during first assembly pass.");
        }
        if (n != 0) {
            System.err.println("Irrecoverable IO error occurred during second assembly pass.");
            return -1;
        }
        assembler.produceFinalOutput();
        return assembler.errorCount;
    }

    void openFirstPassFiles() {
        try {
            this.sourceFile = new BufferedReader(new FileReader(this.sourceFileName + "." + sourceType));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(lineFeed + "File " + this.sourceFileName + "." + sourceType + " not found.");
            this.errorFound = true;
            return;
        }
        catch (IOException iOException) {
            System.err.println(lineFeed + iOException);
            this.errorFound = true;
            return;
        }
        try {
            this.objectFile = new File(this.sourceFileName + ".MO1");
            this.objFileOut = new ObjectOutputStream(new FileOutputStream(this.objectFile));
        }
        catch (IOException iOException) {
            System.err.println(lineFeed + iOException);
            this.errorFound = true;
        }
    }

    void closeFirstPassFiles() {
        try {
            this.sourceFile.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        try {
            this.objFileOut.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    void openSecondPassFiles() {
        try {
            this.objectFile = new File(this.sourceFileName + ".MO1");
            this.objFileIn = new ObjectInputStream(new FileInputStream(this.objectFile));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(lineFeed + "File " + this.sourceFileName + ".MO1 not found.");
            this.errorFound = true;
            return;
        }
        catch (IOException iOException) {
            System.err.println(lineFeed + iOException);
            this.errorFound = true;
            return;
        }
        try {
            this.objFileOut = new ObjectOutputStream(new FileOutputStream(this.sourceFileName + "." + exeType));
        }
        catch (IOException iOException) {
            System.err.println(lineFeed + iOException);
            this.errorFound = true;
        }
    }

    void closeSecondPassFiles() {
        try {
            this.objFileIn.close();
            this.objectFile.delete();
            this.objectFile = null;
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        try {
            this.objFileOut.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    void openFinalFiles() {
        try {
            this.lstFile = new BufferedWriter(new FileWriter(this.sourceFileName + "." + listType));
        }
        catch (IOException iOException) {
            System.err.println(lineFeed + iOException);
            this.errorFound = true;
            return;
        }
        try {
            this.objectFile = new File(this.sourceFileName + "." + exeType);
            this.objFileIn = new ObjectInputStream(new FileInputStream(this.objectFile));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(lineFeed + "File " + this.sourceFileName + "." + exeType + " not found.");
            this.errorFound = true;
            return;
        }
        catch (IOException iOException) {
            System.err.println(lineFeed + iOException);
            this.errorFound = true;
            return;
        }
        if (this.errorCount == 0) {
            try {
                this.mapFile = new BufferedWriter(new FileWriter(this.sourceFileName + "." + mapType));
            }
            catch (IOException iOException) {
                System.err.println(lineFeed + iOException);
                this.errorFound = true;
                return;
            }
        }
    }

    void closeFinalFiles() {
        try {
            this.lstFile.write(formFeed);
            this.lstFile.flush();
            this.lstFile.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        try {
            this.objFileIn.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        if (this.errorCount == 0) {
            try {
                this.mapFile.write(lineFeed);
                this.mapFile.write(formFeed);
                this.mapFile.flush();
                this.mapFile.close();
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        } else {
            this.objectFile.delete();
        }
    }

    public static void main(String[] stringArray) {
        Assembler.assembleFile(stringArray[0]);
    }

    class Instruction
    implements Serializable {
        String mnemonic;
        byte hexCode;
        boolean addrReqd;

        Instruction(String string, byte by, boolean bl) {
            this.mnemonic = string;
            this.hexCode = by;
            this.addrReqd = bl;
        }
    }

    class SymbolEntry {
        String symbol = null;
        String address = null;
        Vector referencedAt;

        SymbolEntry(String string, String string2) {
            this.symbol = string;
            this.address = string2;
            this.referencedAt = new Vector();
        }
    }
}

