/*
 * Decompiled with CFR 0.152.
 */
package MarieSimulator;

import MarieSimulator.Assembler;
import MarieSimulator.TextFileViewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.PlainDocument;

public class MarieEditor
extends JFrame {
    public static final String fileSeparator = System.getProperty("file.separator");
    public static final String lineFeed = System.getProperty("line.separator");
    public static final String EDIT_HELP = "m1edit1.txt";
    public static final String INSTR_HELP = "m1isa1.txt";
    JPanel editorPane;
    JMenuBar menuBar = new JMenuBar();
    JMenu fileMenu = new JMenu();
    JMenuItem newFileItem = new JMenuItem();
    JMenuItem openFileItem = new JMenuItem();
    JMenuItem closeFileItem = new JMenuItem();
    JMenuItem saveFileItem = new JMenuItem();
    JMenuItem saveAsFileItem = new JMenuItem();
    JMenuItem exitItem = new JMenuItem();
    JMenu editMenu = new JMenu();
    JMenuItem editCutItem = new JMenuItem();
    JMenuItem editPasteItem = new JMenuItem();
    JMenuItem editSelectAllItem = new JMenuItem();
    JMenuItem editUndoItem = new JMenuItem();
    JMenuItem editRedoItem = new JMenuItem();
    JMenu assemblerMenu = new JMenu();
    JMenuItem assembleFileItem = new JMenuItem();
    JMenuItem showListItem = new JMenuItem();
    TextFileViewer listingFileViewer;
    JMenu HelpMenu = new JMenu();
    JMenuItem editorHelpItem = new JMenuItem();
    TextFileViewer helpViewer01;
    JMenuItem instrSetHelpItem = new JMenuItem();
    TextFileViewer helpViewer02;
    JScrollPane scrollPane = new JScrollPane();
    JEditorPane sourceCodeArea = new JEditorPane();
    PlainDocument sourceCode;
    JTextField messageField = new JTextField();
    public static final JFileChooser sourceFileChooser = new JFileChooser(System.getProperty("user.dir"));
    public static final String ASSEMBLER_FILE_TYPE = ".mas";
    public static final String LISTING_FILE_TYPE = ".lst";
    String currFileName = null;
    String currFilePrefix = null;
    String currFilePath = null;
    boolean fileUpdated = false;
    boolean defaultFilterOn;
    boolean errorsFound = false;
    boolean exitOnClose = true;
    static /* synthetic */ Class class$MarieSimulator$MarieEditor;
    static /* synthetic */ Class class$MarieSimulator$MarieSim;

    public MarieEditor(boolean bl) {
        this.exitOnClose = bl;
        this.initializeScreen();
    }

    public MarieEditor(String string, boolean bl) {
        this.exitOnClose = bl;
        this.initializeScreen();
        this.currFileName = string;
        this.getFile();
    }

    private void initializeScreen() {
        this.setIconImage(Toolkit.getDefaultToolkit().createImage((class$MarieSimulator$MarieEditor == null ? (class$MarieSimulator$MarieEditor = MarieEditor.class$("MarieSimulator.MarieEditor")) : class$MarieSimulator$MarieEditor).getResource("M.gif")));
        this.editorPane = (JPanel)this.getContentPane();
        this.editorPane.setLayout(new BorderLayout());
        this.setSize(new Dimension(700, 400));
        this.setTitle("MARIE Assembler Code Editor");
        this.fileMenu.setText("File");
        this.fileMenu.setMnemonic('F');
        this.newFileItem.setText("New");
        this.newFileItem.setMnemonic('N');
        this.newFileItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieEditor.this.newFile();
            }
        });
        this.openFileItem.setText("Open");
        this.openFileItem.setMnemonic('O');
        this.openFileItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieEditor.this.openFile();
            }
        });
        this.closeFileItem.setText("Close");
        this.closeFileItem.setMnemonic('C');
        this.closeFileItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieEditor.this.newFile();
            }
        });
        this.saveFileItem.setText("Save");
        this.saveFileItem.setMnemonic('S');
        this.saveFileItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieEditor.this.saveFile();
            }
        });
        this.saveAsFileItem.setText("Save As");
        this.saveAsFileItem.setMnemonic('A');
        this.saveAsFileItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieEditor.this.saveAsFile();
            }
        });
        this.exitItem.setText("Exit");
        this.exitItem.setMnemonic('x');
        this.exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieEditor.this.exitProgram();
            }
        });
        this.fileMenu.add(this.newFileItem);
        this.fileMenu.add(this.openFileItem);
        this.fileMenu.add(this.closeFileItem);
        this.fileMenu.add(this.saveFileItem);
        this.fileMenu.add(this.saveAsFileItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitItem);
        this.editMenu.setText("Edit");
        this.editMenu.setMnemonic('E');
        this.editCutItem.setText("Cut");
        this.editCutItem.setMnemonic('C');
        this.editCutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieEditor.this.sourceCodeArea.cut();
                MarieEditor.this.editPasteItem.setEnabled(true);
            }
        });
        this.editPasteItem.setText("Paste");
        this.editPasteItem.setMnemonic('P');
        this.editPasteItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieEditor.this.sourceCodeArea.paste();
            }
        });
        this.editSelectAllItem.setText("Select All");
        this.editSelectAllItem.setMnemonic('A');
        this.editSelectAllItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieEditor.this.sourceCodeArea.selectAll();
                MarieEditor.this.editPasteItem.setEnabled(true);
            }
        });
        this.editMenu.add(this.editCutItem);
        this.editMenu.add(this.editPasteItem);
        this.editMenu.add(this.editSelectAllItem);
        this.assembleFileItem.setText("Assemble current file");
        this.assembleFileItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieEditor.this.assembleFile();
            }
        });
        this.assemblerMenu.setText("Assemble");
        this.assemblerMenu.add(this.assembleFileItem);
        this.showListItem.setText("Show assembly listing");
        this.showListItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieEditor.this.showListing();
            }
        });
        this.assemblerMenu.add(this.showListItem);
        this.HelpMenu.setToolTipText("Instruction set and editor help.");
        this.HelpMenu.setText("Help");
        this.editorHelpItem.setText("Editor Instructions");
        this.editorHelpItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieEditor.this.editHelp();
            }
        });
        this.HelpMenu.add(this.editorHelpItem);
        this.instrSetHelpItem.setText("Instruction Set Cheat Sheet");
        this.instrSetHelpItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarieEditor.this.instructionSetHelp();
            }
        });
        this.HelpMenu.add(this.instrSetHelpItem);
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.editMenu);
        this.menuBar.add(this.assemblerMenu);
        this.menuBar.add(this.HelpMenu);
        this.setJMenuBar(this.menuBar);
        this.setButtonsForNewFile();
        this.sourceCodeArea.setFont(new Font("Monospaced", 0, 12));
        this.sourceCodeArea.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                if (c != '\u001b') {
                    MarieEditor.this.fileUpdated = true;
                    MarieEditor.this.showMessage(0, MarieEditor.this.createFileMsg());
                    MarieEditor.this.setButtonsForModifiedFile();
                }
            }

            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 8 || n == 127) {
                    MarieEditor.this.fileUpdated = true;
                    MarieEditor.this.showMessage(0, MarieEditor.this.createFileMsg());
                    MarieEditor.this.setButtonsForModifiedFile();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.scrollPane.getViewport().add((Component)this.sourceCodeArea, null);
        this.editorPane.add((Component)this.scrollPane, "Center");
        this.messageField.setFont(new Font("Dialog", 0, 12));
        this.messageField.setBorder(BorderFactory.createLineBorder(Color.black));
        this.showMessage(0, " ");
        this.editorPane.add((Component)this.messageField, "South");
        sourceFileChooser.addChoosableFileFilter(new MarieSourceFileFilter());
        sourceFileChooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MarieEditor.this.defaultFilterOn = sourceFileChooser.getFileFilter() == sourceFileChooser.getAcceptAllFileFilter();
            }
        });
        this.validate();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.setVisible(true);
    }

    void setButtonsForNewFile() {
        this.newFileItem.setEnabled(false);
        this.closeFileItem.setEnabled(false);
        this.saveFileItem.setEnabled(false);
        this.saveAsFileItem.setEnabled(false);
        this.editMenu.setEnabled(true);
        this.editCutItem.setEnabled(true);
        if (Toolkit.getDefaultToolkit().getSystemClipboard() == null) {
            this.editPasteItem.setEnabled(false);
        } else {
            this.editPasteItem.setEnabled(true);
        }
        this.editSelectAllItem.setEnabled(true);
        this.assemblerMenu.setEnabled(false);
        this.assembleFileItem.setEnabled(false);
        this.showListItem.setEnabled(false);
    }

    void setButtonsForLoadedFile() {
        this.newFileItem.setEnabled(true);
        this.closeFileItem.setEnabled(true);
        this.saveAsFileItem.setEnabled(true);
        this.editMenu.setEnabled(true);
        this.editCutItem.setEnabled(true);
        if (Toolkit.getDefaultToolkit().getSystemClipboard() == null) {
            this.editPasteItem.setEnabled(false);
        } else {
            this.editPasteItem.setEnabled(true);
        }
        this.editSelectAllItem.setEnabled(true);
        if (this.currFileName != null && this.currFileName.endsWith(ASSEMBLER_FILE_TYPE)) {
            this.assemblerMenu.setEnabled(true);
            this.assembleFileItem.setEnabled(true);
        }
    }

    void setButtonsForModifiedFile() {
        this.newFileItem.setEnabled(true);
        this.closeFileItem.setEnabled(true);
        this.saveFileItem.setEnabled(true);
        this.saveAsFileItem.setEnabled(true);
        this.editMenu.setEnabled(true);
        this.editCutItem.setEnabled(true);
        if (Toolkit.getDefaultToolkit().getSystemClipboard() == null) {
            this.editPasteItem.setEnabled(false);
        } else {
            this.editPasteItem.setEnabled(true);
        }
        this.editSelectAllItem.setEnabled(true);
        if (this.currFileName != null && this.currFileName.endsWith(ASSEMBLER_FILE_TYPE)) {
            this.assemblerMenu.setEnabled(true);
            this.assembleFileItem.setEnabled(true);
        }
    }

    void openFile() {
        if (!this.abandonOkay()) {
            return;
        }
        if (0 == sourceFileChooser.showOpenDialog(this)) {
            this.currFileName = sourceFileChooser.getSelectedFile().getPath();
            this.getFile();
        }
    }

    void getFile() {
        if (this.currFileName == null) {
            return;
        }
        this.showMessage(0, this.currFileName);
        this.setButtonsForLoadedFile();
        try {
            this.sourceCodeArea.setContentType("text/plain");
            FileInputStream fileInputStream = new FileInputStream(this.currFileName);
            this.sourceCodeArea.read((InputStream)fileInputStream, (Object)null);
        }
        catch (IOException iOException) {
            this.setButtonsForNewFile();
            this.sourceCodeArea.setText("");
            this.currFileName = null;
            this.sourceCodeArea.setText(lineFeed + iOException);
            this.showMessage(1, "File input error.");
            return;
        }
        int n = 0;
        int n2 = 0;
        n = this.currFileName.lastIndexOf(fileSeparator);
        if (n < 0) {
            n = -1;
        }
        if ((n2 = this.currFileName.lastIndexOf(ASSEMBLER_FILE_TYPE)) < 0) {
            this.setButtonsForNewFile();
            this.sourceCodeArea.setText("");
            this.currFileName = null;
            this.sourceCodeArea.setText(lineFeed);
            this.showMessage(1, "Invalid file name.");
            return;
        }
        this.currFilePrefix = this.currFileName.substring(n + 1, n2);
        this.currFilePath = this.currFileName.substring(0, n) + fileSeparator;
        this.showListItem.setEnabled(false);
        if (this.currFileName.endsWith(ASSEMBLER_FILE_TYPE)) {
            this.listingAvailable();
        }
    }

    boolean listingAvailable() {
        try {
            this.listingFileViewer.dispose();
            this.listingFileViewer = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.currFileName == null) {
            return false;
        }
        if (this.currFilePrefix == null) {
            return false;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(this.currFilePath + this.currFilePrefix + LISTING_FILE_TYPE);
        }
        catch (IOException iOException) {
            return false;
        }
        this.showListItem.setEnabled(true);
        return true;
    }

    void newFile() {
        if (this.abandonOkay()) {
            this.sourceCodeArea.setText("");
            this.setButtonsForNewFile();
            this.newFileItem.setEnabled(true);
            this.fileUpdated = false;
            this.currFileName = null;
            this.currFilePrefix = null;
            this.showMessage(0, this.createFileMsg());
        }
    }

    boolean saveFile() {
        if (this.currFileName == null) {
            return this.saveAsFile();
        }
        if (this.currFileName.endsWith(ASSEMBLER_FILE_TYPE)) {
            this.assemblerMenu.setEnabled(true);
            this.assembleFileItem.setEnabled(true);
        }
        try {
            File file = new File(this.currFileName);
            FileWriter fileWriter = new FileWriter(file);
            String string = this.sourceCodeArea.getText();
            fileWriter.write(string);
            fileWriter.close();
            this.fileUpdated = false;
            this.showMessage(0, this.createFileMsg());
            return true;
        }
        catch (IOException iOException) {
            this.showMessage(1, "Error saving " + this.currFileName);
            return false;
        }
    }

    boolean abandonOkay() {
        if (!this.fileUpdated) {
            return true;
        }
        int n = JOptionPane.showConfirmDialog(this, "Save changes?", "Text Edit", 1);
        switch (n) {
            case 0: {
                return this.saveFile();
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    boolean saveAsFile() {
        if (0 == sourceFileChooser.showSaveDialog(this)) {
            this.currFileName = sourceFileChooser.getSelectedFile().getPath();
            if (!this.defaultFilterOn && !this.currFileName.endsWith(ASSEMBLER_FILE_TYPE)) {
                this.currFileName = this.currFileName + ASSEMBLER_FILE_TYPE;
            }
            this.listingAvailable();
            try {
                FileInputStream fileInputStream = new FileInputStream(this.currFileName);
            }
            catch (IOException iOException) {
                return this.saveFile();
            }
            if (this.overlayOkay()) {
                return this.saveFile();
            }
        }
        this.repaint();
        return false;
    }

    boolean overlayOkay() {
        JFrame jFrame = new JFrame("Confirm Overwrite");
        jFrame.setIconImage(Toolkit.getDefaultToolkit().createImage((class$MarieSimulator$MarieSim == null ? (class$MarieSimulator$MarieSim = MarieEditor.class$("MarieSimulator.MarieSim")) : class$MarieSimulator$MarieSim).getResource("M.gif")));
        int n = JOptionPane.showOptionDialog(jFrame, "Rewrite " + this.currFileName + "?", "Rewrite Confirmation", 0, 3, null, new Object[]{"Yes", "No"}, "No");
        return n != 1;
    }

    String createFileMsg() {
        String string = this.currFileName == null ? "Untitled" : this.currFileName;
        if (this.fileUpdated) {
            string = string + " (modified)";
        }
        return string;
    }

    void showMessage(int n, String string) {
        switch (n) {
            case 1: {
                this.messageField.setBackground(Color.orange);
                break;
            }
            case 2: {
                this.messageField.setBackground(Color.yellow);
                break;
            }
            default: {
                this.messageField.setBackground(Color.lightGray);
            }
        }
        this.messageField.setText(" " + string);
        this.messageField.postActionEvent();
    }

    void assembleFile() {
        int n;
        boolean bl = true;
        if (this.fileUpdated) {
            bl = this.saveFile();
        }
        if (!bl) {
            this.showMessage(1, "Fatal error saving file.  Use [Save As].");
            return;
        }
        if (this.currFilePrefix == null) {
            this.getFile();
            if (this.currFilePrefix == null) {
                this.showMessage(2, " No MAS file loaded.");
                return;
            }
        }
        if ((n = Assembler.assembleFile(this.currFileName)) < 0) {
            this.showMessage(1, this.createFileMsg() + " Fatal error in assembler.");
            return;
        }
        if (n > 0) {
            if (n == 1) {
                this.showMessage(2, this.createFileMsg() + " " + n + " error found.");
            } else {
                this.showMessage(2, this.createFileMsg() + " " + n + " errors found.");
            }
            this.showListing();
        } else {
            this.showMessage(0, this.createFileMsg() + " Assembly successful.");
        }
        this.showListItem.setEnabled(true);
    }

    void showListing() {
        if (!this.listingAvailable()) {
            this.showListItem.setEnabled(false);
            return;
        }
        try {
            this.listingFileViewer.show();
            this.listingFileViewer.requestFocus();
        }
        catch (Exception exception) {
            this.listingFileViewer = new TextFileViewer("Assembly Listing for " + this.currFilePrefix + ASSEMBLER_FILE_TYPE, this.currFilePath + this.currFilePrefix + LISTING_FILE_TYPE, false);
            Dimension dimension = this.getSize();
            Dimension dimension2 = this.listingFileViewer.getPreferredSize();
            Point point = this.getLocation();
            this.listingFileViewer.setLocation((dimension.width + point.x / 3) / 2, point.y / 3);
            this.listingFileViewer.show();
        }
    }

    void editHelp() {
        try {
            this.helpViewer01.show();
            this.helpViewer01.requestFocus();
        }
        catch (Exception exception) {
            this.helpViewer01 = new TextFileViewer("MARIE Editor Help", EDIT_HELP, false);
            Dimension dimension = this.getSize();
            Dimension dimension2 = this.helpViewer01.getPreferredSize();
            Point point = this.getLocation();
            this.helpViewer01.setLocation((dimension.width + point.x / 2) / 2, point.y / 2);
            this.helpViewer01.show();
        }
    }

    void instructionSetHelp() {
        try {
            this.helpViewer02.show();
            this.helpViewer02.requestFocus();
        }
        catch (Exception exception) {
            this.helpViewer02 = new TextFileViewer("MARIE Instruction Set", INSTR_HELP, false);
            Dimension dimension = this.getSize();
            Dimension dimension2 = this.helpViewer02.getPreferredSize();
            Point point = this.getLocation();
            this.helpViewer02.setLocation((dimension.width + point.x / 3) / 2, point.y / 3);
            this.helpViewer02.show();
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.exitProgram();
        }
    }

    void exitProgram() {
        JFrame jFrame = new JFrame("Confirm Editor Quit");
        jFrame.setIconImage(Toolkit.getDefaultToolkit().createImage((class$MarieSimulator$MarieSim == null ? (class$MarieSimulator$MarieSim = MarieEditor.class$("MarieSimulator.MarieSim")) : class$MarieSimulator$MarieSim).getResource("M.gif")));
        int n = JOptionPane.showOptionDialog(jFrame, "Really quit editor?", "Quit Editor Confirmation", 0, 3, null, new Object[]{"Yes", "No"}, "Yes");
        if (n == 0) {
            try {
                this.listingFileViewer.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.exitOnClose) {
                System.exit(0);
            } else {
                this.dispose();
                return;
            }
        }
    }

    public static void editNewFile(boolean bl) {
        new MarieEditor(bl);
    }

    public static void editFile(String string, boolean bl) {
        new MarieEditor(string, bl);
    }

    public static void main(String[] stringArray) {
        new MarieEditor(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MarieSourceFileFilter
    extends FileFilter {
        String myFileType = ".mas";

        MarieSourceFileFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().endsWith(this.myFileType);
        }

        public String getDescription() {
            return "*" + this.myFileType;
        }
    }
}

